/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.controller;

import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.service.PhoneNumberService;
import com.saas.shared.enums.Provider;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/phone-numbers"})
@PreAuthorize(value="hasRole('SYSTEM_ADMIN')")
public class AdminPhoneNumberController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminPhoneNumberController.class);
    private final PhoneNumberService phoneNumberService;

    @PostMapping
    public ResponseEntity<PhoneNumber> createPhoneNumber(@RequestBody PhoneNumber phoneNumber) {
        log.info("\ud83d\udcde Admin creating phone number: {} for tenant: {}", (Object)phoneNumber.getPhoneNumber(), (Object)phoneNumber.getTenantId());
        PhoneNumber created = this.phoneNumberService.createPhoneNumber(phoneNumber);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)created);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PhoneNumber> getPhoneNumberById(@PathVariable Long id) {
        return this.phoneNumberService.getPhoneNumberById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping
    public ResponseEntity<List<PhoneNumber>> getAllPhoneNumbers(@RequestParam(required=false) String tenantId, @RequestParam(required=false) Provider provider, @RequestParam(required=false) Boolean isActive) {
        log.info("\ud83d\udccb Fetching phone numbers - tenantId: {}, provider: {}, isActive: {}", new Object[]{tenantId, provider, isActive});
        List phoneNumbers = tenantId != null && provider != null ? this.phoneNumberService.getPhoneNumbersByTenant(tenantId, provider) : (tenantId != null ? this.phoneNumberService.getPhoneNumbersByTenant(tenantId) : (provider != null ? this.phoneNumberService.getAllPhoneNumbersByProvider(provider) : (isActive != null ? this.phoneNumberService.getPhoneNumbersByActiveStatus(isActive) : this.phoneNumberService.getAllPhoneNumbers())));
        return ResponseEntity.ok((Object)phoneNumbers);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<PhoneNumber> updatePhoneNumber(@PathVariable Long id, @RequestBody PhoneNumber updates) {
        log.info("\u270f\ufe0f Admin updating phone number ID: {}", (Object)id);
        try {
            PhoneNumber updated = this.phoneNumberService.updatePhoneNumber(id, updates);
            return ResponseEntity.ok((Object)updated);
        }
        catch (RuntimeException e) {
            log.error("\u274c Phone number not found: {}", (Object)id);
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletePhoneNumber(@PathVariable Long id) {
        log.info("\ud83d\uddd1\ufe0f Admin deleting phone number ID: {}", (Object)id);
        this.phoneNumberService.deletePhoneNumber(id);
        return ResponseEntity.noContent().build();
    }

    @PatchMapping(value={"/{id}/deactivate"})
    public ResponseEntity<Void> deactivatePhoneNumber(@PathVariable Long id) {
        log.info("\u26d4 Admin deactivating phone number ID: {}", (Object)id);
        this.phoneNumberService.deactivatePhoneNumber(id);
        return ResponseEntity.ok().build();
    }

    @PatchMapping(value={"/{id}/activate"})
    public ResponseEntity<Void> activatePhoneNumber(@PathVariable Long id) {
        log.info("\u2705 Admin activating phone number ID: {}", (Object)id);
        this.phoneNumberService.activatePhoneNumber(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/tenant/{tenantId}"})
    public ResponseEntity<List<PhoneNumber>> getPhoneNumbersByTenant(@PathVariable String tenantId) {
        log.info("\ud83d\udccb Fetching all phone numbers for tenant: {}", (Object)tenantId);
        List phoneNumbers = this.phoneNumberService.getPhoneNumbersByTenant(tenantId);
        return ResponseEntity.ok((Object)phoneNumbers);
    }

    @GetMapping(value={"/provider/{provider}"})
    public ResponseEntity<List<PhoneNumber>> getPhoneNumbersByProvider(@PathVariable Provider provider) {
        log.info("\ud83d\udccb Fetching all {} phone numbers", (Object)provider);
        List phoneNumbers = this.phoneNumberService.getAllPhoneNumbersByProvider(provider);
        return ResponseEntity.ok((Object)phoneNumbers);
    }

    @Generated
    public AdminPhoneNumberController(PhoneNumberService phoneNumberService) {
        this.phoneNumberService = phoneNumberService;
    }
}

