/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.repository;

import com.saas.admin.entity.Permission;
import com.saas.admin.entity.Role;
import com.saas.admin.entity.RolePermission;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface RolePermissionRepository
extends JpaRepository<RolePermission, Long> {
    public List<RolePermission> findByRole(Role var1);

    public List<RolePermission> findByPermission(Permission var1);

    public Optional<RolePermission> findByRoleAndPermission(Role var1, Permission var2);

    public boolean existsByRoleAndPermission(Role var1, Permission var2);

    public void deleteByRole(Role var1);

    public void deleteByPermission(Permission var1);

    @Query(value="SELECT CONCAT(p.resource, ':', p.action) FROM RolePermission rp JOIN rp.permission p WHERE rp.role = :role AND p.isActive = true")
    public List<String> findPermissionStringsByRole(@Param(value="role") Role var1);

    @Query(value="SELECT CONCAT(p.resource, ':', p.action) FROM RolePermission rp JOIN rp.permission p WHERE rp.role.id = :roleId AND p.isActive = true")
    public List<String> findPermissionStringsByRoleId(@Param(value="roleId") Long var1);
}

