/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.service;

import com.saas.admin.dto.request.CreateUserRequest;
import com.saas.admin.dto.request.UpdateUserRequest;
import com.saas.admin.dto.response.UserResponse;
import com.saas.admin.entity.User;
import com.saas.admin.repository.UserRepository;
import com.saas.shared.dto.common.PageResponse;
import com.saas.shared.dto.mapper.UserMapper;
import com.saas.shared.enums.UserType;
import com.saas.shared.exception.BusinessException;
import com.saas.shared.exception.ErrorCode;
import com.saas.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    private final UserRepository userRepository;
    private final UserMapper userMapper;
    private final PasswordEncoder passwordEncoder;

    @Transactional
    public UserResponse createUser(CreateUserRequest request) {
        log.info("Creating user with email: {}", (Object)request.getEmail());
        if (this.userRepository.existsByEmail(request.getEmail())) {
            throw new BusinessException(ErrorCode.USER_ALREADY_EXISTS, "User with email " + request.getEmail() + " already exists");
        }
        if (request.getUserType() == UserType.TENANT_USER && request.getTenantId() == null) {
            throw new BusinessException(ErrorCode.INVALID_INPUT, "Tenant ID is required for TENANT_USER");
        }
        User user = this.userMapper.toEntity(request);
        user.setPassword(this.passwordEncoder.encode((CharSequence)request.getPassword()));
        user.setRole(request.getRole() != null ? request.getRole() : "USER");
        user.setStatus("ACTIVE");
        User savedUser = (User)this.userRepository.save((Object)user);
        log.info("User created successfully with ID: {}", (Object)savedUser.getId());
        return this.userMapper.toResponse(savedUser);
    }

    @Transactional(readOnly=true)
    public UserResponse getUserById(Long id) {
        log.debug("Fetching user with ID: {}", (Object)id);
        return this.userRepository.findById((Object)id).map(arg_0 -> ((UserMapper)this.userMapper).toResponse(arg_0)).orElseThrow(() -> new ResourceNotFoundException("User", (Object)id));
    }

    @Transactional(readOnly=true)
    public List<UserResponse> getAllUsers() {
        log.debug("Fetching all users");
        return this.userMapper.toResponseList(this.userRepository.findAll());
    }

    @Transactional(readOnly=true)
    public PageResponse<UserResponse> getUsers(int page, int size) {
        log.debug("Fetching users - page: {}, size: {}", (Object)page, (Object)size);
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        Page userPage = this.userRepository.findAll((Pageable)pageable);
        return PageResponse.builder().content(this.userMapper.toResponseList(userPage.getContent())).page(page).size(size).totalElements(userPage.getTotalElements()).totalPages(userPage.getTotalPages()).hasNext(userPage.hasNext()).hasPrevious(userPage.hasPrevious()).build();
    }

    @Transactional
    public UserResponse updateUser(Long id, UpdateUserRequest request) {
        log.info("Updating user with ID: {}", (Object)id);
        User user = (User)this.userRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("User", (Object)id));
        this.userMapper.updateEntity(request, user);
        User updatedUser = (User)this.userRepository.save((Object)user);
        log.info("User updated successfully with ID: {}", (Object)updatedUser.getId());
        return this.userMapper.toResponse(updatedUser);
    }

    @Transactional
    public void deleteUser(Long id) {
        log.info("Deleting user with ID: {}", (Object)id);
        if (!this.userRepository.existsById((Object)id)) {
            throw new ResourceNotFoundException("User", (Object)id);
        }
        this.userRepository.deleteById((Object)id);
        log.info("User deleted successfully with ID: {}", (Object)id);
    }

    @Generated
    public UserService(UserRepository userRepository, UserMapper userMapper, PasswordEncoder passwordEncoder) {
        this.userRepository = userRepository;
        this.userMapper = userMapper;
        this.passwordEncoder = passwordEncoder;
    }
}

