/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.config;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenApiConfig {
    @Value(value="${server.port:8000}")
    private String serverPort;

    @Bean
    public OpenAPI customOpenAPI() {
        return new OpenAPI().info(new Info().title("SaaS Multi-Tenant API").version("1.0.0").description("Spring Boot 3 multi-tenant SaaS API with JWT authentication and MySQL database-based tenant isolation").contact(new Contact().name("API Support").email("support@saas-api.com")).license(new License().name("MIT License").url("https://opensource.org/licenses/MIT"))).servers(List.of(new Server().url("http://localhost:" + this.serverPort).description("Local Development Server"))).addSecurityItem(new SecurityRequirement().addList("Bearer Authentication")).components(new Components().addSecuritySchemes("Bearer Authentication", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT").description("Enter JWT token")));
    }
}

