/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.core;

import com.saas.shared.core.SchemaMultiTenantConnectionProvider;
import com.saas.shared.core.TenantIdentifierResolverImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MultiTenantConfig {
    @Value(value="${spring.jpa.properties.hibernate.dialect:org.hibernate.dialect.MySQLDialect}")
    private String hibernateDialect;

    @Bean
    public HibernatePropertiesCustomizer hibernatePropertiesCustomizer(SchemaMultiTenantConnectionProvider connectionProvider, TenantIdentifierResolverImpl tenantResolver) {
        return hibernateProperties -> {
            hibernateProperties.put("hibernate.multi_tenant_connection_provider", connectionProvider);
            hibernateProperties.put("hibernate.tenant_identifier_resolver", tenantResolver);
            hibernateProperties.put("hibernate.multiTenancy", "SCHEMA");
            hibernateProperties.put("hibernate.dialect", this.hibernateDialect);
            System.out.println("\ud83d\udd27 MultiTenantConfig: Hibernate multi-tenancy SCHEMA strategy configured");
        };
    }
}

