/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.core;

import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.TenantRepository;
import com.saas.admin.service.TenantSchemaMigrationService;
import com.saas.shared.core.TenantContext;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=100)
public class TenantSchemaUpdateRunner
implements ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantSchemaUpdateRunner.class);
    private final TenantRepository tenantRepository;
    private final TenantSchemaMigrationService migrationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ApplicationArguments args) {
        log.info("=".repeat(80));
        log.info("\ud83d\ude80 Starting automatic tenant schema updates...");
        log.info("=".repeat(80));
        try {
            TenantContext.setTenantId((String)"saas_db");
            List tenants = this.tenantRepository.findAll();
            log.info("\ud83d\udcca Found {} tenant(s) to update", (Object)tenants.size());
            if (tenants.isEmpty()) {
                log.info("\u2139\ufe0f No tenants found. Skipping schema updates.");
                return;
            }
            int successCount = 0;
            int failCount = 0;
            for (Tenant tenant : tenants) {
                String schemaName = tenant.getSchemaName();
                try {
                    log.info("\ud83d\udd04 Updating schema for tenant: {} ({})", (Object)tenant.getTenantName(), (Object)schemaName);
                    this.migrationService.migrateIfNeeded(schemaName);
                    ++successCount;
                    log.info("\u2705 Schema updated successfully for: {}", (Object)schemaName);
                }
                catch (Exception e) {
                    ++failCount;
                    log.error("\u274c Failed to update schema for tenant: {} ({})", new Object[]{tenant.getTenantName(), schemaName, e});
                }
            }
            log.info("=".repeat(80));
            log.info("\ud83c\udfaf Tenant schema update completed!");
            log.info("   \u2705 Success: {} tenant(s)", (Object)successCount);
            if (failCount > 0) {
                log.warn("   \u274c Failed: {} tenant(s)", (Object)failCount);
            }
            log.info("=".repeat(80));
        }
        catch (Exception e) {
            log.error("\u274c CRITICAL: Tenant schema update runner failed", (Throwable)e);
        }
        finally {
            TenantContext.clear();
        }
    }

    @Generated
    public TenantSchemaUpdateRunner(TenantRepository tenantRepository, TenantSchemaMigrationService migrationService) {
        this.tenantRepository = tenantRepository;
        this.migrationService = migrationService;
    }
}

