/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.security;

import com.saas.shared.enums.UserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class UserPrincipal
implements UserDetails {
    private Long id;
    private String email;
    private String password;
    private String role;
    private UserType userType;
    private List<String> permissions;

    public UserPrincipal(Long id, String email, String password, String role) {
        this.id = id;
        this.email = email;
        this.password = password;
        this.role = role;
        this.userType = null;
    }

    public UserPrincipal(Long id, String email, String password, String role, UserType userType) {
        this.id = id;
        this.email = email;
        this.password = password;
        this.role = role;
        this.userType = userType;
        this.permissions = new ArrayList();
    }

    public UserPrincipal(Long id, String email, String password, String role, UserType userType, List<String> permissions) {
        this.id = id;
        this.email = email;
        this.password = password;
        this.role = role;
        this.userType = userType;
        this.permissions = permissions != null ? permissions : new ArrayList();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        if (this.role != null) {
            authorities.add(new SimpleGrantedAuthority("ROLE_" + this.role));
        }
        if (this.userType != null) {
            authorities.add(new SimpleGrantedAuthority("ROLE_" + this.userType.name()));
        }
        if (this.permissions != null && !this.permissions.isEmpty()) {
            for (String permission : this.permissions) {
                authorities.add(new SimpleGrantedAuthority(permission));
            }
        }
        return authorities;
    }

    public String getUsername() {
        return this.email;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public UserType getUserType() {
        return this.userType;
    }

    @Generated
    public List<String> getPermissions() {
        return this.permissions;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Generated
    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    @Generated
    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserPrincipal)) {
            return false;
        }
        UserPrincipal other = (UserPrincipal)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        UserType this$userType = this.getUserType();
        UserType other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !this$userType.equals(other$userType)) {
            return false;
        }
        List this$permissions = this.getPermissions();
        List other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserPrincipal;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        UserType $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : $userType.hashCode());
        List $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserPrincipal(id=" + this.getId() + ", email=" + this.getEmail() + ", password=" + this.getPassword() + ", role=" + this.getRole() + ", userType=" + String.valueOf(this.getUserType()) + ", permissions=" + String.valueOf(this.getPermissions()) + ")";
    }
}

