/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.shared.enums.Provider;
import com.saas.voip.service.TelnyxCostService;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voip/telnyx"})
public class TelnyxCallEndController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelnyxCallEndController.class);
    private final TelnyxCostService telnyxCostService;
    private final PhoneNumberRepository phoneNumberRepository;
    private final TenantRepository tenantRepository;

    @PostMapping(value={"/call-ended"})
    public ResponseEntity<Map<String, Object>> handleCallEnded(@RequestBody Map<String, Object> payload) {
        try {
            log.info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            log.info("\u2551     TELNYX CALL ENDED WEBHOOK RECEIVED               \u2551");
            log.info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
            log.info("\ud83d\udce5 [TelnyxCallEnd] Raw payload received: {}", payload);
            Map data = (Map)payload.get("data");
            if (data == null) {
                log.error("\u274c [TelnyxCallEnd] No 'data' field in payload!");
                return ResponseEntity.ok(Map.of("status", "error", "reason", "missing_data"));
            }
            log.info("\ud83d\udce6 [TelnyxCallEnd] Data field extracted: {}", (Object)data);
            Map eventPayload = (Map)data.get("payload");
            if (eventPayload == null) {
                log.error("\u274c [TelnyxCallEnd] No 'payload' field in data!");
                return ResponseEntity.ok(Map.of("status", "error", "reason", "missing_payload"));
            }
            log.info("\ud83d\udce6 [TelnyxCallEnd] Event payload extracted: {}", (Object)eventPayload);
            String eventType = (String)eventPayload.get("event_type");
            String callSessionId = (String)eventPayload.get("call_session_id");
            String fromNumber = (String)eventPayload.get("from");
            String toNumber = (String)eventPayload.get("to");
            String state = (String)eventPayload.get("state");
            log.info("\ud83c\udfaf [TelnyxCallEnd] Parsed event data:");
            log.info("   \u251c\u2500 Event Type: {}", (Object)eventType);
            log.info("   \u251c\u2500 Call Session ID: {}", (Object)callSessionId);
            log.info("   \u251c\u2500 From: {}", (Object)fromNumber);
            log.info("   \u251c\u2500 To: {}", (Object)toNumber);
            log.info("   \u2514\u2500 State: {}", (Object)state);
            if (callSessionId == null || callSessionId.isEmpty()) {
                log.error("\u274c [TelnyxCallEnd] Missing call_session_id!");
                return ResponseEntity.ok(Map.of("status", "error", "reason", "missing_call_session_id"));
            }
            if ("call.hangup".equals(eventType)) {
                log.info("\u2705 [TelnyxCallEnd] Event type is 'call.hangup' - processing call cost...");
                log.info("\ud83d\udd0d [TelnyxCallEnd] Identifying tenant schema for number: {}", (Object)toNumber);
                String schemaName = this.identifyTenantSchema(toNumber);
                if (schemaName != null) {
                    log.info("\u2705 [TelnyxCallEnd] Tenant schema identified: {}", (Object)schemaName);
                    log.info("\ud83d\ude80 [TelnyxCallEnd] Calling TelnyxCostService.fetchAndSaveCallCost()...");
                    try {
                        this.telnyxCostService.fetchAndSaveCallCost(callSessionId, fromNumber, toNumber, schemaName);
                        log.info("\u2705 [TelnyxCallEnd] Telnyx call cost retrieval initiated successfully!");
                        log.info("   \u251c\u2500 Session ID: {}", (Object)callSessionId);
                        log.info("   \u251c\u2500 Tenant Schema: {}", (Object)schemaName);
                        log.info("   \u2514\u2500 Status: Cost fetch in progress");
                    }
                    catch (Exception costEx) {
                        log.error("\u274c [TelnyxCallEnd] EXCEPTION while fetching call cost!", (Throwable)costEx);
                        log.error("\u274c [TelnyxCallEnd] Exception type: {}", (Object)costEx.getClass().getName());
                        log.error("\u274c [TelnyxCallEnd] Exception message: {}", (Object)costEx.getMessage());
                    }
                } else {
                    log.warn("\u26a0\ufe0f [TelnyxCallEnd] Could not identify tenant schema for number: {}", (Object)toNumber);
                    log.warn("\u26a0\ufe0f [TelnyxCallEnd] Possible reasons:");
                    log.warn("   \u251c\u2500 Phone number not found in database");
                    log.warn("   \u251c\u2500 Phone number not assigned to TELNYX provider");
                    log.warn("   \u2514\u2500 Tenant not found for phone number");
                }
            } else {
                log.info("\u23ed\ufe0f [TelnyxCallEnd] Event type is '{}' (not 'call.hangup') - skipping cost fetch", (Object)eventType);
            }
            log.info("\u2705 [TelnyxCallEnd] Webhook processed successfully");
            return ResponseEntity.ok(Map.of("status", "received"));
        }
        catch (Exception e) {
            log.error("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            log.error("\u2551     CRITICAL ERROR IN TELNYX CALL END WEBHOOK        \u2551");
            log.error("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
            log.error("\u274c [TelnyxCallEnd] EXCEPTION in handleCallEnded()", (Throwable)e);
            log.error("\u274c [TelnyxCallEnd] Exception type: {}", (Object)e.getClass().getName());
            log.error("\u274c [TelnyxCallEnd] Exception message: {}", (Object)e.getMessage());
            log.error("\u274c [TelnyxCallEnd] Stack trace:", (Throwable)e);
            return ResponseEntity.ok(Map.of("status", "error", "message", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String identifyTenantSchema(String phoneNumber) {
        log.info("\ud83d\udd0e [TelnyxCallEnd] identifyTenantSchema() - Looking up phone number: {}", (Object)phoneNumber);
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            log.warn("\u26a0\ufe0f [TelnyxCallEnd] Phone number is null or empty!");
            return null;
        }
        try {
            log.info("\ud83c\udfaf [TelnyxCallEnd] Setting TenantContext to 'saas_db' for admin database query");
            TenantContext.setTenantId((String)"saas_db");
            log.info("\ud83d\udd0d [TelnyxCallEnd] Querying phone_numbers table for: {}", (Object)phoneNumber);
            Optional phoneOpt = this.phoneNumberRepository.findByPhoneNumber(phoneNumber);
            if (phoneOpt.isEmpty()) {
                log.warn("\u26a0\ufe0f [TelnyxCallEnd] Phone number NOT FOUND in database: {}", (Object)phoneNumber);
                String string = null;
                return string;
            }
            PhoneNumber phone = (PhoneNumber)phoneOpt.get();
            log.info("\u2705 [TelnyxCallEnd] Phone number found in database!");
            log.info("   \u251c\u2500 Phone Number: {}", (Object)phone.getPhoneNumber());
            log.info("   \u251c\u2500 Provider: {}", (Object)phone.getProvider());
            log.info("   \u251c\u2500 Tenant ID: {}", (Object)phone.getTenantId());
            log.info("   \u2514\u2500 Active: {}", (Object)phone.getIsActive());
            if (phone.getProvider() != Provider.TELNYX) {
                log.warn("\u26a0\ufe0f [TelnyxCallEnd] Phone number provider is {} (not TELNYX) - skipping", (Object)phone.getProvider());
                String string = null;
                return string;
            }
            String tenantId = phone.getTenantId();
            log.info("\ud83d\udd0d [TelnyxCallEnd] Querying tenants table for tenant ID: {}", (Object)tenantId);
            Optional tenantOpt = this.tenantRepository.findByTenantId(tenantId);
            if (tenantOpt.isEmpty()) {
                log.warn("\u26a0\ufe0f [TelnyxCallEnd] Tenant NOT FOUND for tenant ID: {}", (Object)tenantId);
                String string = null;
                return string;
            }
            Tenant tenant = (Tenant)tenantOpt.get();
            String schemaName = tenant.getSchemaName();
            log.info("\u2705 [TelnyxCallEnd] Tenant found!");
            log.info("   \u251c\u2500 Tenant ID: {}", (Object)tenant.getTenantId());
            log.info("   \u251c\u2500 Tenant Name: {}", (Object)tenant.getTenantName());
            log.info("   \u2514\u2500 Schema Name: {}", (Object)schemaName);
            String string = schemaName;
            return string;
        }
        catch (Exception e) {
            log.error("\u274c [TelnyxCallEnd] EXCEPTION in identifyTenantSchema()", (Throwable)e);
            log.error("\u274c [TelnyxCallEnd] Exception type: {}", (Object)e.getClass().getName());
            log.error("\u274c [TelnyxCallEnd] Exception message: {}", (Object)e.getMessage());
            String string = null;
            return string;
        }
        finally {
            TenantContext.clear();
            log.info("\ud83e\uddf9 [TelnyxCallEnd] TenantContext cleared after schema lookup");
        }
    }

    @Generated
    public TelnyxCallEndController(TelnyxCostService telnyxCostService, PhoneNumberRepository phoneNumberRepository, TenantRepository tenantRepository) {
        this.telnyxCostService = telnyxCostService;
        this.phoneNumberRepository = phoneNumberRepository;
        this.tenantRepository = tenantRepository;
    }
}

