/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.shared.enums.Provider;
import com.saas.tenant.entity.CallCostRecord;
import com.saas.tenant.entity.InboundCallRequest;
import com.saas.tenant.service.CallCostTrackingService;
import com.saas.tenant.service.InboundCallService;
import com.saas.voip.service.TelnyxSmsService;
import jakarta.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voip/telnyx/ai"})
public class TelnyxEventController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelnyxEventController.class);
    private final InboundCallService inboundCallService;
    private final TelnyxSmsService telnyxSmsService;
    private final PhoneNumberRepository phoneNumberRepository;
    private final TenantRepository tenantRepository;
    private final CallCostTrackingService callCostTrackingService;

    @PostMapping(value={"/conversation-event"})
    public ResponseEntity<Map<String, Object>> handleConversationEvent(HttpServletRequest request, @RequestParam Map<String, String> allParams) {
        try {
            log.info("=== TELNYX AI CONVERSATION EVENT ===");
            log.info("\ud83d\udce5 Content-Type: {}", (Object)request.getContentType());
            log.info("\ud83d\udce5 All parameters: {}", allParams);
            if (allParams.isEmpty()) {
                log.warn("\u26a0\ufe0f No parameters received");
                return ResponseEntity.ok(Map.of("status", "no_params"));
            }
            String callbackSource = allParams.get("CallbackSource");
            if ("call-cost-events".equals(callbackSource)) {
                this.handleCallCostEvent(allParams);
            }
            return ResponseEntity.ok(Map.of("status", "received", "params_count", allParams.size()));
        }
        catch (Exception e) {
            log.error("\u274c Error processing Telnyx event", (Throwable)e);
            return ResponseEntity.ok(Map.of("status", "error"));
        }
    }

    private void handleCallCostEvent(Map<String, String> params) {
        try {
            log.info("\ud83d\udcb0 Processing call-cost-events webhook");
            String callSid = params.get("CallSid");
            String from = params.get("From");
            String to = params.get("To");
            if (callSid == null || from == null || to == null) {
                log.warn("\u26a0\ufe0f Missing required params (CallSid, From, or To) in call-cost webhook");
                return;
            }
            String callCostKey = "CallCost[" + callSid + "]";
            String billedDurationKey = "BilledDurationSeconds[" + callSid + "]";
            String costStr = params.get(callCostKey);
            String durationStr = params.get(billedDurationKey);
            if (costStr == null) {
                log.warn("\u26a0\ufe0f No CallCost found for CallSid: {}", (Object)callSid);
                return;
            }
            double totalCost = Double.parseDouble(costStr);
            int billedSeconds = durationStr != null ? Integer.parseInt(durationStr) : 0;
            log.info("\ud83d\udcb5 Call cost received - CallSid: {}, Cost: ${}, Duration: {}s", new Object[]{callSid, totalCost, billedSeconds});
            Optional phoneOpt = this.phoneNumberRepository.findByPhoneNumber(to);
            if (phoneOpt.isEmpty() || ((PhoneNumber)phoneOpt.get()).getProvider() != Provider.TELNYX) {
                log.warn("\u26a0\ufe0f No Telnyx phone number found for: {}", (Object)to);
                return;
            }
            PhoneNumber phoneNumber = (PhoneNumber)phoneOpt.get();
            String tenantId = phoneNumber.getTenantId();
            Optional tenantOpt = this.tenantRepository.findByTenantId(tenantId);
            if (tenantOpt.isEmpty()) {
                log.error("\u274c Tenant not found for phone: {}", (Object)to);
                return;
            }
            Tenant tenant = (Tenant)tenantOpt.get();
            String schemaName = tenant.getSchemaName();
            CallCostRecord costRecord = new CallCostRecord();
            costRecord.setCallSid(callSid);
            costRecord.setProvider("TELNYX");
            costRecord.setCallDurationSeconds(Integer.valueOf(billedSeconds));
            costRecord.setCost(BigDecimal.valueOf(totalCost));
            costRecord.setCurrency("USD");
            costRecord.setFromNumber(from);
            costRecord.setToNumber(to);
            costRecord.setCallEndTime(LocalDateTime.now());
            HashMap<String, Object> costDetails = new HashMap<String, Object>();
            costDetails.put("billed_duration_seconds", billedSeconds);
            costDetails.put("total_cost_usd", totalCost);
            costDetails.put("tenant_schema", schemaName);
            costDetails.put("webhook_source", "call-cost-events");
            costRecord.setCostDetails(costDetails);
            this.callCostTrackingService.saveCallCost(costRecord);
            log.info("\u2705 Call cost saved to admin database (saas_db) - CallSid: {}, Tenant: {}, Cost: ${}", new Object[]{callSid, tenantId, totalCost});
        }
        catch (Exception e) {
            log.error("\u274c Error processing call cost event", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGatherCompleted(Map<String, Object> payload, String callSessionId, String schemaName, PhoneNumber phoneNumber) {
        try {
            Map gatheredData = (Map)payload.get("gathered_data");
            if (gatheredData == null) {
                log.warn("\u26a0\ufe0f No gathered data in Gather completed event");
                return;
            }
            log.info("\ud83d\udccb Gather completed - Extracted data: {}", (Object)gatheredData);
            String patientName = (String)gatheredData.get("patient_name");
            String patientPhone = (String)gatheredData.get("patient_phone");
            String illness = (String)gatheredData.get("reason_for_visit");
            String doctorName = (String)gatheredData.get("doctor_name");
            String appointmentDateStr = (String)gatheredData.get("appointment_date");
            String appointmentTimeStr = (String)gatheredData.get("appointment_time");
            TenantContext.setTenantId((String)schemaName);
            try {
                InboundCallRequest callRequest = new InboundCallRequest();
                callRequest.setCallSid(callSessionId);
                callRequest.setNom(patientName);
                callRequest.setTelephone(patientPhone);
                callRequest.setMaladie(illness);
                callRequest.setDoctorName(doctorName);
                if (appointmentDateStr != null && appointmentTimeStr != null) {
                    try {
                        String dateTimeStr = appointmentDateStr + " " + appointmentTimeStr;
                        LocalDateTime appointmentDateTime = LocalDateTime.parse(dateTimeStr, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                        callRequest.setAppointmentDateTime(appointmentDateTime);
                    }
                    catch (Exception e) {
                        log.warn("Failed to parse appointment date/time: {} {}", (Object)appointmentDateStr, (Object)appointmentTimeStr);
                    }
                }
                this.inboundCallService.savePatientRequest(callRequest);
                log.info("\u2705 Telnyx gathered data saved to tenant schema: {}", (Object)schemaName);
            }
            finally {
                TenantContext.clear();
            }
        }
        catch (Exception e) {
            log.error("Error handling Gather completed", (Throwable)e);
        }
    }

    private void handleFunctionCall(Map<String, Object> payload, String callSessionId, String schemaName, PhoneNumber phoneNumber) {
        try {
            String functionName = (String)payload.get("function_name");
            Map arguments = (Map)payload.get("arguments");
            log.info("\ud83d\udd27 Function called: {} with args: {}", (Object)functionName, (Object)arguments);
            if ("confirm_appointment".equals(functionName)) {
                this.handleConfirmAppointment(callSessionId, schemaName, arguments, phoneNumber);
            }
        }
        catch (Exception e) {
            log.error("Error handling function call", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConfirmAppointment(String callSessionId, String schemaName, Map<String, Object> arguments, PhoneNumber phoneNumber) {
        try {
            TenantContext.setTenantId((String)schemaName);
            try {
                String smsSid;
                Optional requestOpt = this.inboundCallService.getPatientRequestByCallSid(callSessionId);
                if (requestOpt.isEmpty()) {
                    log.warn("\u26a0\ufe0f Call request not found for CallSid: {}", (Object)callSessionId);
                    return;
                }
                InboundCallRequest request = (InboundCallRequest)requestOpt.get();
                request.setAppointmentConfirmed(Boolean.valueOf(true));
                this.inboundCallService.savePatientRequest(request);
                if (request.getTelephone() != null && request.getAppointmentDateTime() != null && (smsSid = this.telnyxSmsService.sendAppointmentConfirmationSms(phoneNumber.getPhoneNumber(), request.getTelephone(), request.getNom(), request.getDoctorName(), request.getAppointmentDateTime(), null)) != null) {
                    request.setSmsSent(Boolean.valueOf(true));
                    request.setSmsSid(smsSid);
                    this.inboundCallService.savePatientRequest(request);
                    log.info("\u2705 SMS confirmation sent via Telnyx - SID: {}", (Object)smsSid);
                }
                log.info("\u2705 Appointment confirmed in tenant schema: {}", (Object)schemaName);
            }
            finally {
                TenantContext.clear();
            }
        }
        catch (Exception e) {
            log.error("Error confirming appointment", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTranscriptUpdate(Map<String, Object> payload, String callSessionId, String schemaName) {
        block5: {
            try {
                List transcript = (List)payload.get("transcript");
                if (transcript == null || transcript.isEmpty()) break block5;
                log.info("\ud83d\udcdd Transcript updated for call: {} - {} messages", (Object)callSessionId, (Object)transcript.size());
                TenantContext.setTenantId((String)schemaName);
                try {
                    this.inboundCallService.updateTranscript(callSessionId, transcript);
                    log.info("\u2705 Transcript updated in tenant schema: {}", (Object)schemaName);
                }
                finally {
                    TenantContext.clear();
                }
            }
            catch (Exception e) {
                log.error("Error updating transcript", (Throwable)e);
            }
        }
    }

    @GetMapping(value={"/health"})
    public String health() {
        return "Telnyx AI Event Service is running!";
    }

    @Generated
    public TelnyxEventController(InboundCallService inboundCallService, TelnyxSmsService telnyxSmsService, PhoneNumberRepository phoneNumberRepository, TenantRepository tenantRepository, CallCostTrackingService callCostTrackingService) {
        this.inboundCallService = inboundCallService;
        this.telnyxSmsService = telnyxSmsService;
        this.phoneNumberRepository = phoneNumberRepository;
        this.tenantRepository = tenantRepository;
        this.callCostTrackingService = callCostTrackingService;
    }
}

