/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.saas.shared.core.TenantContext;
import com.saas.tenant.entity.CallCostRecord;
import com.saas.tenant.service.CallCostTrackingService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TelnyxCostService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelnyxCostService.class);
    @Value(value="${telnyx.api.key:}")
    private String telnyxApiKey;
    private final CallCostTrackingService callCostTrackingService;
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate = new RestTemplate();

    public void fetchAndSaveCallCost(String callSessionId, String fromNumber, String toNumber, String tenantSchemaName) {
        log.info("\ud83d\ude80 [TelnyxCostService] fetchAndSaveCallCost() CALLED - SessionId: {}, From: {}, To: {}, Tenant: {}", new Object[]{callSessionId, fromNumber, toNumber, tenantSchemaName});
        if (this.telnyxApiKey == null || this.telnyxApiKey.isEmpty()) {
            log.error("\u274c [TelnyxCostService] Telnyx API Key not configured - CANNOT fetch call cost!");
            log.error("\u274c [TelnyxCostService] Please set telnyx.api.key in application properties");
            return;
        }
        log.info("\u2705 [TelnyxCostService] Telnyx API Key configured");
        try {
            String url = String.format("https://api.telnyx.com/v2/detail_records?filter[call_session_id]=%s", callSessionId);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Bearer " + this.telnyxApiKey);
            headers.set("Accept", "application/json");
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            log.info("\ud83d\udd0d [TelnyxCostService] Calling Telnyx Detail Records API: {}", (Object)url);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            log.info("\ud83d\udce1 [TelnyxCostService] Telnyx API response status: {}", (Object)response.getStatusCode());
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("\ud83d\udcc4 [TelnyxCostService] Telnyx API response body: {}", response.getBody());
                JsonNode root = this.objectMapper.readTree((String)response.getBody());
                JsonNode data = root.get("data");
                if (data != null && data.isArray() && data.size() > 0) {
                    JsonNode record = data.get(0);
                    String cost = record.has("cost") ? record.get("cost").asText() : null;
                    String duration = record.has("duration") ? record.get("duration").asText() : null;
                    String startTime = record.has("start_time") ? record.get("start_time").asText() : null;
                    String endTime = record.has("end_time") ? record.get("end_time").asText() : null;
                    log.info("\ud83d\udcb0 [TelnyxCostService] Parsed data - Cost: {} USD, Duration: {}s", (Object)cost, (Object)duration);
                    if (cost != null && !cost.isEmpty()) {
                        this.saveCallCost(callSessionId, cost, duration, startTime, endTime, fromNumber, toNumber, tenantSchemaName);
                    } else {
                        log.warn("\u26a0\ufe0f [TelnyxCostService] No cost data available in Telnyx API response");
                    }
                } else {
                    log.warn("\u26a0\ufe0f [TelnyxCostService] No detail records found for call session: {}", (Object)callSessionId);
                    log.warn("\u26a0\ufe0f [TelnyxCostService] Call detail records may not be available yet (wait a few minutes after call ends)");
                }
            } else {
                log.error("\u274c [TelnyxCostService] Failed to fetch - HTTP Status: {}, Body: {}", (Object)response.getStatusCode(), response.getBody());
            }
        }
        catch (Exception e) {
            log.error("\u274c [TelnyxCostService] EXCEPTION while fetching call cost for SessionId: {}", (Object)callSessionId, (Object)e);
            log.error("\u274c [TelnyxCostService] Exception message: {}", (Object)e.getMessage());
            log.error("\u274c [TelnyxCostService] Exception class: {}", (Object)e.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCallCost(String callSessionId, String costStr, String durationStr, String startTimeStr, String endTimeStr, String from, String to, String tenantSchemaName) {
        try {
            log.info("\ud83d\udcbe [TelnyxCostService] Calling callCostTrackingService.saveCallCost()...");
            CallCostRecord record = new CallCostRecord();
            record.setProvider("TELNYX");
            record.setCallSid(callSessionId);
            record.setFromNumber(from);
            record.setToNumber(to);
            if (costStr != null && !costStr.isEmpty()) {
                try {
                    BigDecimal cost = new BigDecimal(costStr).abs();
                    record.setCost(cost);
                    record.setCurrency("USD");
                    log.info("\ud83d\udcb5 [TelnyxCostService] Cost set: {} USD", (Object)cost);
                }
                catch (NumberFormatException e) {
                    log.error("\u274c [TelnyxCostService] Failed to parse cost: {}", (Object)costStr, (Object)e);
                }
            }
            if (durationStr != null && !durationStr.isEmpty()) {
                try {
                    Integer duration = Integer.parseInt(durationStr);
                    record.setCallDurationSeconds(duration);
                    log.info("\u23f1\ufe0f [TelnyxCostService] Duration set: {} seconds", (Object)duration);
                }
                catch (NumberFormatException e) {
                    log.error("\u274c [TelnyxCostService] Failed to parse duration: {}", (Object)durationStr, (Object)e);
                }
            }
            DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
            if (startTimeStr != null && !startTimeStr.isEmpty()) {
                try {
                    LocalDateTime startTime = ZonedDateTime.parse(startTimeStr, formatter).toLocalDateTime();
                    record.setCallStartTime(startTime);
                    log.info("\ud83d\udd50 [TelnyxCostService] Start time set: {}", (Object)startTime);
                }
                catch (Exception e) {
                    log.warn("\u26a0\ufe0f [TelnyxCostService] Failed to parse start time: {}", (Object)startTimeStr);
                }
            }
            if (endTimeStr != null && !endTimeStr.isEmpty()) {
                try {
                    LocalDateTime endTime = ZonedDateTime.parse(endTimeStr, formatter).toLocalDateTime();
                    record.setCallEndTime(endTime);
                    log.info("\ud83d\udd51 [TelnyxCostService] End time set: {}", (Object)endTime);
                }
                catch (Exception e) {
                    log.warn("\u26a0\ufe0f [TelnyxCostService] Failed to parse end time: {}", (Object)endTimeStr);
                }
            }
            log.info("\ud83c\udfaf [TelnyxCostService] Setting TenantContext to saas_db for ADMIN database save");
            TenantContext.setTenantId((String)"saas_db");
            try {
                this.callCostTrackingService.saveCallCost(record);
                log.info("\u2705 [TelnyxCostService] Telnyx call cost saved to ADMIN database (saas_db)!");
            }
            finally {
                TenantContext.clear();
                log.info("\ud83e\uddf9 [TelnyxCostService] TenantContext cleared");
            }
        }
        catch (Exception e) {
            log.error("\u274c [TelnyxCostService] EXCEPTION while saving call cost!", (Throwable)e);
            log.error("\u274c [TelnyxCostService] Exception type: {}, Message: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
    }

    @Generated
    public TelnyxCostService(CallCostTrackingService callCostTrackingService, ObjectMapper objectMapper) {
        this.callCostTrackingService = callCostTrackingService;
        this.objectMapper = objectMapper;
    }
}

