/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TelnyxVoiceAIService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelnyxVoiceAIService.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Value(value="${telnyx.api.key:}")
    private String telnyxApiKey;
    @Value(value="${telnyx.voice.ai.assistant.id:}")
    private String defaultAIAssistantId;
    private static final String TELNYX_API_BASE = "https://api.telnyx.com/v2";

    public void startVoiceAI(String callControlId, String aiAssistantId) {
        try {
            String url = "https://api.telnyx.com/v2/calls/" + callControlId + "/actions/start_ai_assistant";
            HashMap<String, String> payload = new HashMap<String, String>();
            payload.put("ai_assistant_id", aiAssistantId != null ? aiAssistantId : this.defaultAIAssistantId);
            payload.put("client_state", this.encodeMetadata(callControlId));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(this.telnyxApiKey);
            HttpEntity request = new HttpEntity(payload, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request, Map.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("\u2705 Telnyx Voice AI started on call: {}", (Object)callControlId);
            } else {
                log.error("\u274c Failed to start Voice AI. Status: {}", (Object)response.getStatusCode());
            }
        }
        catch (Exception e) {
            log.error("Error starting Telnyx Voice AI on call: {}", (Object)callControlId, (Object)e);
        }
    }

    public void stopVoiceAI(String callControlId) {
        try {
            String url = "https://api.telnyx.com/v2/calls/" + callControlId + "/actions/stop_ai_assistant";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(this.telnyxApiKey);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request, Map.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("\ud83d\uded1 Telnyx Voice AI stopped on call: {}", (Object)callControlId);
            }
        }
        catch (Exception e) {
            log.error("Error stopping Telnyx Voice AI on call: {}", (Object)callControlId, (Object)e);
        }
    }

    public Map<String, Object> getConversationTranscript(String callSessionId) {
        try {
            String url = "https://api.telnyx.com/v2/ai/conversations/" + callSessionId;
            HttpHeaders headers = new HttpHeaders();
            headers.setBearerAuth(this.telnyxApiKey);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, Map.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("\ud83d\udcc4 Retrieved conversation transcript for: {}", (Object)callSessionId);
                return (Map)response.getBody();
            }
        }
        catch (Exception e) {
            log.error("Error retrieving conversation transcript: {}", (Object)callSessionId, (Object)e);
        }
        return Map.of();
    }

    public void updateAIInstructions(String aiAssistantId, String instructions) {
        try {
            String url = "https://api.telnyx.com/v2/ai/assistants/" + aiAssistantId;
            HashMap<String, String> payload = new HashMap<String, String>();
            payload.put("instructions", instructions);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(this.telnyxApiKey);
            HttpEntity request = new HttpEntity(payload, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PATCH, request, Map.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("\u2705 Updated AI assistant instructions: {}", (Object)aiAssistantId);
            }
        }
        catch (Exception e) {
            log.error("Error updating AI instructions for: {}", (Object)aiAssistantId, (Object)e);
        }
    }

    private String encodeMetadata(String callControlId) {
        try {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("call_control_id", callControlId);
            metadata.put("timestamp", String.valueOf(System.currentTimeMillis()));
            return this.objectMapper.writeValueAsString(metadata);
        }
        catch (Exception e) {
            log.error("Error encoding metadata", (Throwable)e);
            return "{}";
        }
    }

    @Generated
    public TelnyxVoiceAIService() {
    }
}

