# 🎯 Demo Data - API Testing Guide

Ce fichier contient des données de démo prêtes à l'emploi pour tester tous les endpoints de l'API avec Insomnia ou Postman.

---

## 🔐 Authentication Demo Users

### System Admin (Pre-configured via SQL)
```json
{
  "email": "superadmin@system.com",
  "password": "Admin@123"
}
```
**Rôles**: `SYSTEM_ADMIN`, accès complet à tous les endpoints admin.

**⚠️ Note**: Les SYSTEM_ADMIN sont créés via le script SQL `CREATE_SYSTEM_ADMIN.sql`, pas via l'API.

### Tenant User (tenant_1)
```json
{
  "email": "tenant1@example.com",
  "password": "tenant1password"
}
```
**Rôles**: `TENANT_USER`, accès uniquement aux endpoints tenant self-service.

---

## 📝 Register New Tenant (Signup)

### Create New Tenant + Tenant User
```json
{
  "email": "newtenant@example.com",
  "password": "securepassword123",
  "firstName": "Jean",
  "lastName": "Dupont",
  "tenantName": "Clinique La Rive Bleue"
}
```
**Endpoint**: `POST /api/auth/register`

**Ce qui est créé automatiquement** :
1. ✅ Nouveau tenant avec ID unique
2. ✅ Base de données dédiée (ex: `tenant_clinique_la_rive_bleue`)
3. ✅ Tables tenant (inbound_call_requests, call_cost_records, etc.)
4. ✅ Utilisateur TENANT_USER avec rôle ADMIN pour ce tenant
5. ✅ JWT token retourné directement (auto-login)

**Exemples supplémentaires** :

### Register Tenant 2
```json
{
  "email": "cabinet.nord@example.com",
  "password": "SecurePass456!",
  "firstName": "Marie",
  "lastName": "Martin",
  "tenantName": "Cabinet Médical Nord"
}
```
**Schema créé** : `tenant_cabinet_medical_nord`

### Register Tenant 3
```json
{
  "email": "clinique.sud@example.com",
  "password": "MyPassword789",
  "firstName": "Pierre",
  "lastName": "Bernard",
  "tenantName": "Clinique Sud Santé"
}
```
**Schema créé** : `tenant_clinique_sud_sante`

**⚠️ Erreurs possibles** :
- Email déjà utilisé → `400 BAD REQUEST`
- Nom de tenant déjà existant → `400 BAD REQUEST`
- Champs manquants → `400 BAD REQUEST`

---

## 📞 Phone Numbers Demo Data

### Create Twilio Phone Number
```json
{
  "phoneNumber": "+33612345678",
  "tenantId": "tenant_1",
  "provider": "TWILIO",
  "friendlyName": "Clinique La Rive Bleue - Main Line",
  "isActive": true,
  "description": "Main clinic reception line for patient appointments"
}
```

### Create ElevenLabs Phone Number
```json
{
  "phoneNumber": "+33698765432",
  "tenantId": "tenant_1",
  "provider": "ELEVENLABS",
  "friendlyName": "Clinique AI Assistant",
  "isActive": true,
  "description": "ElevenLabs conversational AI for patient intake"
}
```

### Create Telnyx Phone Number
```json
{
  "phoneNumber": "+33123456789",
  "tenantId": "tenant_2",
  "provider": "TELNYX",
  "friendlyName": "Cabinet Médical Nord",
  "isActive": true,
  "description": "Telnyx VoIP line for medical consultations"
}
```

---

## 🎛️ VoIP Configuration Demo Data

### Create Telnyx VoIP Config
```json
{
  "provider": "TELNYX",
  "aiAssistantId": "ai_telnyx_assistant_abc123",
  "aiType": "TELNYX_NATIVE_AI",
  "messagingProfileId": "msg_profile_xyz789",
  "streamUrl": null,
  "isActive": true,
  "metadata": {
    "region": "eu-west-1",
    "environment": "production"
  }
}
```
**Endpoint**: `POST /api/admin/voip-configs/tenant_1`

### Create Twilio VoIP Config (WebSocket Stream)
```json
{
  "provider": "TWILIO",
  "aiAssistantId": null,
  "aiType": "WEBSOCKET_STREAM",
  "messagingProfileId": null,
  "streamUrl": "wss://your-websocket-server.com/stream",
  "isActive": true,
  "metadata": {
    "openai_model": "gpt-4o-realtime",
    "voice": "alloy"
  }
}
```
**Endpoint**: `POST /api/admin/voip-configs/tenant_1`

### Update VoIP Config
```json
{
  "aiAssistantId": "ai_updated_assistant_456",
  "streamUrl": "wss://new-stream-url.com/endpoint",
  "isActive": true
}
```
**Endpoint**: `PUT /api/admin/voip-configs/tenant_1/TELNYX`

---

## 🔐 RBAC - Roles Demo Data

### Create "Tenant Admin" Role
```json
{
  "name": "TENANT_ADMIN",
  "description": "Full administrative access to tenant resources including users, calls, and VoIP configuration",
  "isSystem": false
}
```

### Create "Call Manager" Role
```json
{
  "name": "CALL_MANAGER",
  "description": "Manage and view call records, cost analytics, and patient data",
  "isSystem": false
}
```

### Create "VoIP Specialist" Role
```json
{
  "name": "VOIP_SPECIALIST",
  "description": "Configure and manage VoIP settings for the tenant",
  "isSystem": false
}
```

### Create "Cost Analyst" Role
```json
{
  "name": "COST_ANALYST",
  "description": "View-only access to cost analytics and billing data",
  "isSystem": false
}
```

### Update Role
```json
{
  "description": "Updated: Full admin access with additional permissions",
  "isActive": true
}
```

---

## 🔑 RBAC - Permissions Demo Data

### Create "tenant:read" Permission
```json
{
  "resource": "tenant",
  "action": "read",
  "description": "View tenant information and settings",
  "isSystem": true
}
```

### Create "tenant:write" Permission
```json
{
  "resource": "tenant",
  "action": "write",
  "description": "Create and update tenant information",
  "isSystem": false
}
```

### Create "voip:read" Permission
```json
{
  "resource": "voip",
  "action": "read",
  "description": "View VoIP configurations and settings",
  "isSystem": false
}
```

### Create "voip:write" Permission
```json
{
  "resource": "voip",
  "action": "write",
  "description": "Create and update VoIP configurations",
  "isSystem": false
}
```

### Create "cost:read" Permission
```json
{
  "resource": "cost",
  "action": "read",
  "description": "View cost analytics and billing data",
  "isSystem": false
}
```

### Create "call:read" Permission
```json
{
  "resource": "call",
  "action": "read",
  "description": "View call records and patient data",
  "isSystem": false
}
```

### Create "call:write" Permission
```json
{
  "resource": "call",
  "action": "write",
  "description": "Modify call records and patient information",
  "isSystem": false
}
```

### Create "user:manage" Permission
```json
{
  "resource": "user",
  "action": "manage",
  "description": "Full user management including creation, updates, and deletion",
  "isSystem": false
}
```

---

## 🔗 Assign Permissions to Roles

### Assign Permissions to "TENANT_ADMIN" Role
```json
{
  "permissionIds": [1, 2, 3, 4, 5, 6, 7, 8]
}
```
**Endpoint**: `POST /api/admin/roles/{roleId}/permissions`

**Explication**: Assigne toutes les permissions (tenant:read, tenant:write, voip:read, voip:write, cost:read, call:read, call:write, user:manage) au rôle TENANT_ADMIN.

### Assign Permissions to "CALL_MANAGER" Role
```json
{
  "permissionIds": [5, 6]
}
```
**Permissions**: `cost:read`, `call:read` uniquement.

### Assign Permissions to "VOIP_SPECIALIST" Role
```json
{
  "permissionIds": [3, 4]
}
```
**Permissions**: `voip:read`, `voip:write` uniquement.

### Assign Permissions to "COST_ANALYST" Role
```json
{
  "permissionIds": [5]
}
```
**Permissions**: `cost:read` uniquement (lecture seule).

---

## 📡 Tenant - VoIP Self-Service Demo

### Update Own VoIP Config (Tenant User)
```json
{
  "aiAssistantId": "ai_tenant_custom_assistant",
  "aiType": "TELNYX_NATIVE_AI",
  "streamUrl": "wss://tenant-custom-stream.com/endpoint",
  "isActive": true
}
```
**Endpoint**: `PUT /api/tenant/voip-configs/TELNYX`

**Note**: Le tenant ne peut modifier QUE sa propre configuration, pas celle des autres tenants.

---

## 🎙️ VoIP Webhooks Demo Data

### Twilio Incoming Call Webhook
```
Form Data (application/x-www-form-urlencoded):
From: +33612345678
To: +33187654321
CallSid: CA1234567890abcdef
CallStatus: ringing
```
**Endpoint**: `POST /api/voip/incoming-call`

### Twilio Status Callback (Cost Capture)
```
Form Data:
CallSid: CA1234567890abcdef
CallStatus: completed
CallDuration: 120
Price: -0.015
PriceUnit: USD
```
**Endpoint**: `POST /api/voip/twilio/status-callback`

### ElevenLabs Post-Call Webhook
```json
{
  "call_id": "elevenlabs_call_123",
  "call_session_id": "CA1234567890abcdef",
  "transcript": [
    {"role": "assistant", "message": "Bonjour, cabinet médical, comment puis-je vous aider?"},
    {"role": "user", "message": "Bonjour, je voudrais prendre rendez-vous avec le Dr. Martin."},
    {"role": "assistant", "message": "Bien sûr. Pouvez-vous me donner votre nom complet?"},
    {"role": "user", "message": "Jean Dupont."},
    {"role": "assistant", "message": "Et votre numéro de téléphone?"},
    {"role": "user", "message": "06 12 34 56 78."},
    {"role": "assistant", "message": "Parfait. Je vous propose le 20 octobre à 14h30. Cela vous convient?"},
    {"role": "user", "message": "Oui, c'est parfait."},
    {"role": "assistant", "message": "Excellent. Votre rendez-vous est confirmé pour le 20 octobre à 14h30 avec le Dr. Martin. Merci et à bientôt!"}
  ],
  "analysis": {
    "evaluation_criteria_results": {
      "Nom": "Jean Dupont",
      "Téléphone": "+33612345678",
      "Rendez-vous confirmé": "Oui - 2025-10-20 14:30",
      "Docteur": "Dr. Martin"
    }
  },
  "metadata": {
    "twilio_phone_number": "+33187654321",
    "twilio_call_sid": "CA1234567890abcdef"
  },
  "subscription_usage": {
    "total_cost": 0.45,
    "currency": "USD"
  },
  "duration_seconds": 180
}
```
**Endpoint**: `POST /api/voip/elevenlabs/post-call-webhook`

### Telnyx Call End Webhook
```json
{
  "call_control_id": "telnyx_call_456",
  "call_leg_id": "leg_789",
  "to": "+33187654321",
  "from": "+33612345678",
  "direction": "incoming",
  "state": "hangup"
}
```
**Endpoint**: `POST /api/voip/telnyx/call-end`

---

## 💰 Cost Analytics Demo Queries

### Get Tenant Costs (Admin)
**Query Parameters**:
```
startDate: 2025-01-01T00:00:00
endDate: 2025-12-31T23:59:59
```
**Endpoint**: `GET /api/admin/costs/tenant/tenant_1?startDate=2025-01-01T00:00:00&endDate=2025-12-31T23:59:59`

### Get My Costs (Tenant User)
**Query Parameters**:
```
provider: ELEVENLABS
startDate: 2025-01-01T00:00:00
endDate: 2025-01-31T23:59:59
```
**Endpoint**: `GET /api/tenant/costs?provider=ELEVENLABS&startDate=2025-01-01T00:00:00&endDate=2025-01-31T23:59:59`

---

## 📞 Call Records Demo Queries

### Get Inbound Calls (Paginated)
**Query Parameters**:
```
page: 0
size: 10
```
**Endpoint**: `GET /api/tenant/calls/inbound?page=0&size=10`

### Get Call Records by Provider
**Query Parameters**:
```
provider: ELEVENLABS
```
**Endpoint**: `GET /api/tenant/calls/records?provider=ELEVENLABS`

### Get Calls by Patient Phone
**Endpoint**: `GET /api/tenant/calls/patient/+33612345678`

### Get Recent Calls
**Query Parameters**:
```
limit: 5
```
**Endpoint**: `GET /api/tenant/calls/recent?limit=5`

---

## 🧪 Testing Workflow Recommendations

### 0️⃣ Initial Setup (First Time Only)
1. **Create System Admin** → Exécuter le script SQL `CREATE_SYSTEM_ADMIN.sql`
   ```bash
   mysql -u root -p < CREATE_SYSTEM_ADMIN.sql
   ```
2. **Register New Tenants** → `POST /api/auth/register` (crée tenant + DB + user)
   - Tenant 1: Clinique La Rive Bleue
   - Tenant 2: Cabinet Médical Nord
   - Chaque registration retourne un JWT token automatiquement

### 1️⃣ Setup Phase (Admin Only)
1. **Login as System Admin** → `POST /api/auth/login` avec `superadmin@system.com`
2. **Create Permissions** → Créer toutes les permissions (tenant:read, tenant:write, voip:read, voip:write, cost:read, call:read, call:write, user:manage)
3. **Create Roles** → Créer les rôles (TENANT_ADMIN, CALL_MANAGER, VOIP_SPECIALIST, COST_ANALYST)
4. **Assign Permissions to Roles** → Assigner les permissions aux rôles créés
5. **Create Phone Numbers** → Créer des numéros pour Twilio, ElevenLabs, Telnyx
6. **Create VoIP Configs** → Configurer VoIP pour tenant_1 et tenant_2

### 2️⃣ Runtime Phase (Tenant Self-Service)
1. **Login as Tenant User** → `POST /api/auth/login` avec les credentials du tenant
2. **View My VoIP Config** → `GET /api/tenant/voip-configs/TELNYX`
3. **Update My VoIP Config** → `PUT /api/tenant/voip-configs/TELNYX`
4. **Check Config Status** → `GET /api/tenant/voip-configs/TELNYX/status`
5. **View My Costs** → `GET /api/tenant/costs`
6. **View My Calls** → `GET /api/tenant/calls/records`

### 3️⃣ Production Simulation (Webhooks)
1. **Simulate Incoming Call** → POST à `/api/voip/incoming-call` (Twilio)
2. **Simulate Call End** → POST à `/api/voip/twilio/status-callback` (Cost capture)
3. **Simulate ElevenLabs Post-Call** → POST à `/api/voip/elevenlabs/post-call-webhook` (Patient data extraction)
4. **Verify Call Record Created** → `GET /api/tenant/calls/records`
5. **Verify Cost Tracked** → `GET /api/tenant/costs`

### 📋 Quick Testing Checklist

✅ **Phase 0 - Bootstrap** (Une seule fois)
- [ ] Créer SYSTEM_ADMIN via SQL
- [ ] Register tenant 1 via `/api/auth/register`
- [ ] Register tenant 2 via `/api/auth/register`

✅ **Phase 1 - Admin Setup** (Par SYSTEM_ADMIN)
- [ ] Login admin + récupérer token
- [ ] Créer 8 permissions (tenant, voip, cost, call)
- [ ] Créer 4 rôles (TENANT_ADMIN, CALL_MANAGER, etc.)
- [ ] Assigner permissions aux rôles
- [ ] Créer phone numbers pour chaque tenant
- [ ] Créer VoIP configs pour chaque tenant

✅ **Phase 2 - Tenant Usage** (Par TENANT_USER)
- [ ] Login tenant + récupérer token
- [ ] Consulter config VoIP
- [ ] Modifier config VoIP
- [ ] Consulter coûts
- [ ] Consulter appels

✅ **Phase 3 - Production** (Webhooks)
- [ ] Tester webhooks Twilio/Telnyx/ElevenLabs
- [ ] Vérifier données persistées
- [ ] Vérifier coûts trackés

---

## 🔑 Environment Variables Required

Pour tester localement (ngrok), configurez ces variables :

```bash
# Database
DATABASE_URL=jdbc:mysql://localhost:3306/saas_db
MYSQL_HOST=localhost
MYSQL_PORT=3306
MYSQL_DATABASE=saas_db
MYSQL_USER=root
MYSQL_PASSWORD=yourpassword

# JWT
JWT_SECRET=your-super-secret-jwt-key-change-in-production

# Twilio (optionnel)
TWILIO_ACCOUNT_SID=ACxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
TWILIO_AUTH_TOKEN=your_twilio_auth_token
TWILIO_PHONE_NUMBER=+33187654321

# Telnyx (optionnel)
TELNYX_API_KEY=your_telnyx_api_key
TELNYX_AI_ASSISTANT_ID=ai_telnyx_assistant_id

# OpenAI (optionnel)
OPENAI_API_KEY=sk-proj-xxxxxxxxxxxxxxxxxxxxx

# ElevenLabs (optionnel)
ELEVENLABS_API_KEY=your_elevenlabs_api_key
```

---

## 📦 Quick Start with Insomnia

### Configuration Initiale
1. **Import Collection** : `API_DOCUMENTATION_INSOMNIA.json` dans Insomnia
2. **Set Environment Variables** :
   - `base_url`: `http://localhost:8000` (ou votre URL ngrok)
   - `admin_token`: Copier après Login Admin
   - `tenant_token`: Copier après Login Tenant User ou Register

### Workflow Complet (First Time Setup)

**Étape 1 - Bootstrap (SQL + Register)**
1. Créer SYSTEM_ADMIN : Exécuter `CREATE_SYSTEM_ADMIN.sql`
2. **Register Tenant 1** : `POST /api/auth/register` → Récupérer token
3. **Register Tenant 2** : `POST /api/auth/register` → Récupérer token

**Étape 2 - Admin Setup (avec admin_token)**
1. **Login Admin** : `POST /api/auth/login` → Copier token dans `admin_token`
2. **Create Permissions** : Créer 8 permissions (tenant, voip, cost, call)
3. **Create Roles** : Créer 4 rôles
4. **Assign Permissions** : Assigner permissions aux rôles
5. **Create Phone Numbers** : Créer numéros pour chaque tenant
6. **Create VoIP Configs** : Configurer VoIP pour chaque tenant

**Étape 3 - Tenant Usage (avec tenant_token)**
1. **Login Tenant** : `POST /api/auth/login` → Copier token dans `tenant_token`
2. **View VoIP Config** : `GET /api/tenant/voip-configs/TELNYX`
3. **Update VoIP Config** : `PUT /api/tenant/voip-configs/TELNYX`
4. **View Costs** : `GET /api/tenant/costs`
5. **View Calls** : `GET /api/tenant/calls/records`

**Étape 4 - Production Simulation (no auth)**
1. **Webhooks** : Tester Twilio/ElevenLabs/Telnyx webhooks
2. **Verify** : Vérifier données dans tenant calls/costs

---

**Documentation générée le 18 Octobre 2025**  
**Version API**: 1.0.0  
**Compatible avec**: Insomnia, Postman, Thunder Client
