# Guide de Configuration Telnyx

Ce guide explique comment configurer Telnyx Voice AI avec votre API Spring Boot pour utiliser le voicebot médical français.

---

## Prérequis

1. Un compte Telnyx (inscription sur [telnyx.com](https://telnyx.com))
2. Une URL publique pour votre API (ngrok pour le développement local)
3. Les variables d'environnement configurées dans votre `.env`

---

## Étape 1 : Créer un Compte Telnyx

1. **Inscription** : Allez sur [portal.telnyx.com](https://portal.telnyx.com) et créez un compte
2. **Vérification** : Complétez la vérification d'identité (requis pour les numéros de téléphone)
3. **Recharge** : Ajoutez du crédit à votre compte (minimum $5-10 recommandé)

---

## Étape 2 : Obtenir votre Clé API Telnyx

1. **Accédez à API Keys** :
   - Menu : `API Keys` dans le portail Telnyx
   
2. **Créer une nouvelle clé** :
   - Cliquez sur `Create API Key`
   - Nom : `Spring Boot SaaS API`
   - Permissions : `Full Access` ou sélectionnez `Voice` + `Messaging` + `AI`
   
3. **Copiez la clé** : Format `KEYxxxxxxxxxxxxxxxxxxxxxxxxxxxxx`
   
4. **Ajoutez à votre `.env`** :
   ```bash
   TELNYX_API_KEY=KEYxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
   ```

---

## Étape 3 : Acheter un Numéro de Téléphone

1. **Phone Numbers** → `Search & Buy Numbers`

2. **Recherchez un numéro** :
   - Pays : France (`+33`) ou votre pays
   - Type : `Voice + Messaging`
   - Capabilities : Cochez `Voice`, `SMS`, `MMS`

3. **Achetez le numéro** : ~$1-5/mois selon le pays

4. **Notez le numéro** : Format E.164 (ex: `+33123456789`)

---

## Étape 4 : Créer un Voice AI Assistant

### 4.1 Accéder à AI Assistants

- Menu : `Voice AI` → `Assistants`
- Cliquez : `Create Assistant`

### 4.2 Configuration de l'Assistant

**Basic Info :**
- **Name** : `French Medical Assistant`
- **Language** : `French (fr-FR)`
- **Voice** : `alloy` ou `nova` (voix féminines) / `onyx` (voix masculine)

**Instructions Système (Prompt) :**
```
Tu es un assistant médical virtuel pour la Clinique La Rive Bleue en France. 

Ton rôle :
1. Accueillir chaleureusement les patients qui appellent
2. Demander leur nom complet, date de naissance, et numéro de téléphone
3. Demander la raison de leur appel (symptômes ou maladie)
4. Proposer une liste de médecins disponibles et laisser le patient choisir
5. Proposer des créneaux de rendez-vous (date et heure)
6. Confirmer le rendez-vous avec le patient
7. Indiquer qu'un SMS de confirmation sera envoyé

Médecins disponibles :
- Dr. Sophie Martin (Médecin généraliste)
- Dr. Jean Dupont (Cardiologue)
- Dr. Marie Leblanc (Pédiatre)
- Dr. Pierre Rousseau (Dermatologue)

Sois professionnel, empathique et rassurant. Parle français naturellement.
```

**Functions (Gather Data)** - Configurez les données à extraire :

```json
{
  "name": "capture_patient_info",
  "description": "Capture patient information and appointment details",
  "parameters": {
    "type": "object",
    "properties": {
      "patient_name": {
        "type": "string",
        "description": "Full name of the patient"
      },
      "patient_phone": {
        "type": "string",
        "description": "Patient's phone number"
      },
      "patient_birthdate": {
        "type": "string",
        "description": "Patient's date of birth (format: YYYY-MM-DD)"
      },
      "reason_for_visit": {
        "type": "string",
        "description": "Reason for the medical visit or symptoms"
      },
      "doctor_name": {
        "type": "string",
        "description": "Name of the chosen doctor"
      },
      "appointment_date": {
        "type": "string",
        "description": "Appointment date (format: YYYY-MM-DD)"
      },
      "appointment_time": {
        "type": "string",
        "description": "Appointment time (format: HH:mm)"
      }
    },
    "required": ["patient_name", "patient_phone"]
  }
}
```

**Function pour confirmation** (optionnel) :
```json
{
  "name": "confirm_appointment",
  "description": "Confirm the appointment and trigger SMS sending",
  "parameters": {
    "type": "object",
    "properties": {
      "confirmed": {
        "type": "boolean",
        "description": "Whether the patient confirmed the appointment"
      }
    },
    "required": ["confirmed"]
  }
}
```

### 4.3 Sauvegardez et Copiez l'ID

- Cliquez `Save`
- **Copiez l'Assistant ID** : Format `ai_xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx`
- Ajoutez à `.env` :
  ```bash
  TELNYX_VOICE_AI_ASSISTANT_ID=ai_xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
  ```

---

## Étape 5 : Configurer le Messaging Profile (SMS)

### 5.1 Créer un Messaging Profile

1. Menu : `Messaging` → `Messaging Profiles`
2. Cliquez : `Create Messaging Profile`
3. **Name** : `SaaS Medical Clinic SMS`

### 5.2 Associer votre numéro

- Dans le profil créé, onglet `Phone Numbers`
- Cliquez `Add Phone Numbers`
- Sélectionnez le numéro acheté à l'étape 3

### 5.3 Copiez le Profile ID

- **Messaging Profile ID** : Format `xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx`
- Ajoutez à `.env` :
  ```bash
  TELNYX_MESSAGING_PROFILE_ID=xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
  ```

---

## Étape 6 : Configurer les Webhooks Telnyx

### 6.1 Obtenir votre URL Publique

**Option A - Développement local avec ngrok :**
```bash
ngrok http 8000
# Copiez l'URL HTTPS : https://xxxx-xx-xx-xx-xx.ngrok-free.app
```

**Option B - Production Replit :**
```bash
# Votre URL de déploiement Replit
https://your-app.repl.co
```

### 6.2 Configurer Voice Webhooks

1. **Menu** : `Voice` → `Applications`
2. **Create Application** : `SaaS Medical Voice App`

3. **Inbound Settings** :
   - **Webhook URL** : `https://your-domain/api/voip/telnyx/incoming-call`
   - **Webhook Method** : `POST`
   - **Webhook Format** : `JSON`

4. **Events** - Activez ces webhooks :
   - ✅ `call.initiated`
   - ✅ `call.answered`
   - ✅ `call.hangup`
   - ✅ `call.recording.saved` (optionnel)

5. **AI Webhooks** (section avancée) :
   - **AI Event Webhook URL** : `https://your-domain/api/voip/telnyx/ai/conversation-event`
   - **Events** :
     - ✅ `ai.assistant.gather.completed`
     - ✅ `ai.assistant.function.called`
     - ✅ `ai.assistant.transcript.updated`

### 6.3 Configurer SMS Webhooks

1. **Menu** : `Messaging` → `Settings`
2. **Default Webhook** :
   - **URL** : `https://your-domain/api/voip/telnyx/sms/status-callback`
   - **Method** : `POST`
   - **Format** : `JSON`

3. **Events** - Activez :
   - ✅ `message.sent`
   - ✅ `message.delivered`
   - ✅ `message.failed`
   - ✅ `message.received` (optionnel)

### 6.4 Associer le Numéro à l'Application Voice

1. Retournez à **Phone Numbers** → Votre numéro
2. Section `Voice Settings` :
   - **Connection Type** : `Application`
   - **Application** : Sélectionnez `SaaS Medical Voice App`
3. Sauvegardez

---

## Étape 7 : Ajouter le Numéro dans votre Base de Données

### Via API (recommandé)

```bash
curl -X POST http://localhost:8000/api/admin/phone-numbers \
  -H "Authorization: Bearer YOUR_ADMIN_JWT_TOKEN" \
  -H "Content-Type: application/json" \
  -d '{
    "phoneNumber": "+33123456789",
    "provider": "TELNYX",
    "tenantId": "tenant_acme",
    "friendlyName": "Ligne principale clinique",
    "description": "Numéro Telnyx avec Voice AI",
    "isActive": true
  }'
```

### Via SQL (temporaire pour test)

```sql
-- Se connecter au schema admin
USE saas_db;

INSERT INTO phone_numbers 
  (phone_number, provider, tenant_id, friendly_name, description, is_active)
VALUES 
  ('+33123456789', 'TELNYX', 'tenant_acme', 'Ligne principale', 'Telnyx Voice AI', true);
```

---

## Étape 8 : Variables d'Environnement Complètes

Votre fichier `.env` doit contenir :

```bash
# Database
MYSQL_HOST=localhost
MYSQL_PORT=3306
MYSQL_DATABASE=saas_db
MYSQL_USER=root
MYSQL_PASSWORD=password

# Server
SERVER_PORT=8000
SERVER_BASE_URL=https://xxxx.ngrok-free.app  # Votre URL publique

# JWT
SESSION_SECRET=your-secret-key-min-256-bits

# OpenAI (pour Twilio)
OPENAI_API_KEY=sk-xxxxx

# Twilio
TWILIO_ACCOUNT_SID=ACxxxxx
TWILIO_AUTH_TOKEN=xxxxx
TWILIO_PHONE_NUMBER=+1234567890

# Telnyx (NOUVEAU)
TELNYX_API_KEY=KEYxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
TELNYX_VOICE_AI_ASSISTANT_ID=ai_xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
TELNYX_MESSAGING_PROFILE_ID=xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
```

---

## Étape 9 : Tester l'Intégration

### 9.1 Démarrer votre serveur

```bash
# Avec ngrok (développement local)
ngrok http 8000

# Dans un autre terminal
mvn spring-boot:run
```

### 9.2 Appeler votre numéro Telnyx

1. **Appelez** le numéro Telnyx depuis votre téléphone
2. **Vérifiez** que l'assistant répond en français
3. **Testez** le flow complet :
   - Donner votre nom, date de naissance, téléphone
   - Expliquer votre problème médical
   - Choisir un médecin
   - Sélectionner un créneau
   - Confirmer le rendez-vous

### 9.3 Vérifier les Logs

```bash
# Dans le terminal Spring Boot
tail -f logs/application.log | grep "TELNYX"
```

Vous devriez voir :
```
📞 Telnyx webhook received
📞 Identified Tenant ID: tenant_acme for Telnyx number: +33123456789
✅ Telnyx call data saved to tenant schema: tenant_acme_corp
🤖 AI Event Type: ai.assistant.gather.completed
📋 Gather completed - Extracted data: {patient_name=...}
✅ Telnyx gathered data saved for call: call_xxxxx
📨 SMS Telnyx envoyé avec succès ! ID: xxxxx
```

### 9.4 Vérifier la Base de Données

```sql
-- Vérifier les données capturées
SELECT * FROM tenant_acme_corp.inbound_call_request 
ORDER BY created_at DESC LIMIT 5;

-- Vérifier le SMS envoyé
SELECT nom, telephone, doctor_name, appointment_date_time, sms_sent, sms_status
FROM tenant_acme_corp.inbound_call_request 
WHERE sms_sent = true;
```

---

## Étape 10 : Surveillance et Debug

### 10.1 Dashboard Telnyx

- **Calls** : `Voice` → `Call Logs` - Voir tous les appels
- **SMS** : `Messaging` → `Message Logs` - Voir les SMS envoyés
- **AI Conversations** : `Voice AI` → `Conversations` - Voir les transcriptions

### 10.2 Webhooks Logs Telnyx

- Menu : `Developers` → `Webhook Logs`
- Filtrez par votre application pour voir les requêtes/réponses

### 10.3 Common Issues

**Problème** : L'assistant ne répond pas
- ✅ Vérifiez que le numéro est associé à l'application Voice
- ✅ Vérifiez que l'Assistant ID est correct dans `.env`
- ✅ Vérifiez les webhook logs Telnyx

**Problème** : Pas de données extraites
- ✅ Vérifiez la fonction `capture_patient_info` dans l'Assistant
- ✅ Vérifiez les logs Spring Boot pour voir les événements AI

**Problème** : SMS non reçu
- ✅ Vérifiez le Messaging Profile ID
- ✅ Vérifiez que le numéro est associé au profil
- ✅ Vérifiez le webhook SMS status callback

---

## Comparaison Twilio vs Telnyx

| Feature | Twilio + OpenAI | Telnyx Voice AI |
|---------|----------------|-----------------|
| **Voice** | $0.0085/min | $0.012/min (bundled) |
| **AI Processing** | $0.30/min (OpenAI) | Inclus |
| **SMS** | $0.0079/msg | $0.0035/msg |
| **Setup** | WebSocket complexe | Webhook simple |
| **Total Cost** | ~$0.30/min | ~$0.012/min |
| **Savings** | - | **95% moins cher** 💰 |

---

## Ressources Utiles

- **Telnyx Docs** : [developers.telnyx.com](https://developers.telnyx.com)
- **Voice AI Guide** : [Telnyx Voice AI Docs](https://developers.telnyx.com/docs/voice/ai)
- **API Reference** : [Telnyx API](https://developers.telnyx.com/docs/api/v2)
- **Postman Collection** : [Telnyx Postman](https://www.postman.com/telnyx)

---

## Support

Si vous rencontrez des problèmes :
1. Vérifiez les logs Spring Boot : `logs/application.log`
2. Vérifiez les webhook logs Telnyx : Dashboard → Developers → Webhook Logs
3. Support Telnyx : `support@telnyx.com` ou chat en ligne

**Note** : Telnyx Voice AI est actuellement en beta dans certaines régions. Contactez le support pour l'activer si nécessaire.

---

## Next Steps

Une fois configuré, vous pouvez :
1. **Tester en production** avec un vrai numéro français
2. **Comparer les coûts** Twilio vs Telnyx sur 1 mois
3. **Optimiser l'Assistant** en ajustant le prompt système
4. **Ajouter des fonctionnalités** comme les rappels SMS automatiques

Bonne configuration ! 🚀
