package com.saas.shared.audit;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface AuditRepository extends JpaRepository<AuditLog, Long> {
    List<AuditLog> findByUserId(String userId);
    List<AuditLog> findByTenantId(String tenantId);
    List<AuditLog> findByEntityTypeAndEntityId(String entityType, String entityId);
}
