package com.saas.shared.dto.mapper;

import com.saas.admin.dto.request.CreateUserRequest;
import com.saas.admin.dto.response.UserResponse;
import com.saas.admin.entity.User;
import com.saas.tenant.dto.request.CreateTenantUserRequest;
import com.saas.tenant.dto.response.TenantUserResponse;
import com.saas.tenant.entity.TenantUser;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;

import java.util.List;

@Mapper(componentModel = "spring")
public interface UserMapper {
    
    UserResponse toResponse(User user);
    
    List<UserResponse> toResponseList(List<User> users);
    
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "createdAt", ignore = true)
    @Mapping(target = "updatedAt", ignore = true)
    @Mapping(target = "password", ignore = true)
    User toEntity(CreateUserRequest request);
    
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "email", ignore = true)
    @Mapping(target = "password", ignore = true)
    @Mapping(target = "userType", ignore = true)
    @Mapping(target = "tenantId", ignore = true)
    @Mapping(target = "createdAt", ignore = true)
    @Mapping(target = "updatedAt", ignore = true)
    void updateEntity(com.saas.admin.dto.request.UpdateUserRequest request, @MappingTarget User user);
    
    TenantUserResponse toTenantUserResponse(TenantUser user);
    
    List<TenantUserResponse> toTenantUserResponseList(List<TenantUser> users);
    
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "createdAt", ignore = true)
    @Mapping(target = "updatedAt", ignore = true)
    @Mapping(target = "password", ignore = true)
    TenantUser toTenantUserEntity(CreateTenantUserRequest request);
    
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "email", ignore = true)
    @Mapping(target = "password", ignore = true)
    @Mapping(target = "createdAt", ignore = true)
    @Mapping(target = "updatedAt", ignore = true)
    void updateTenantUserEntity(com.saas.tenant.dto.request.UpdateTenantUserRequest request, @MappingTarget TenantUser user);
}
