package com.saas.tenant.controller;

import com.saas.tenant.entity.TenantUser;
import com.saas.tenant.repository.TenantUserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/tenant/users")
public class TenantUserController {
    
    @Autowired
    private TenantUserRepository tenantUserRepository;
    
    @GetMapping
    public ResponseEntity<List<TenantUser>> getAllUsers() {
        return ResponseEntity.ok(tenantUserRepository.findAll());
    }
    
    @GetMapping("/{id}")
    public ResponseEntity<TenantUser> getUserById(@PathVariable Long id) {
        return tenantUserRepository.findById(id)
            .map(ResponseEntity::ok)
            .orElse(ResponseEntity.notFound().build());
    }
}
