package com.saas.tenant.repository;

import com.saas.tenant.entity.InboundCallRequest;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface InboundCallRequestRepository extends JpaRepository<InboundCallRequest, Long> {
    
    Optional<InboundCallRequest> findByCallSid(String callSid);
    
    List<InboundCallRequest> findAllByCallSid(String callSid);
    
    Optional<InboundCallRequest> findBySmsSid(String smsSid);
    
    List<InboundCallRequest> findByTelephone(String telephone);
}
