/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.controller;

import com.saas.admin.dto.request.AssignPermissionsRequest;
import com.saas.admin.dto.request.CreateRoleRequest;
import com.saas.admin.dto.request.UpdateRoleRequest;
import com.saas.admin.dto.response.RoleResponse;
import com.saas.admin.entity.Role;
import com.saas.admin.service.RoleService;
import com.saas.shared.dto.mapper.RoleMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/roles"})
@PreAuthorize(value="hasRole('SYSTEM_ADMIN')")
@Tag(name="Admin Roles", description="Role management for RBAC system")
public class AdminRoleController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminRoleController.class);
    private final RoleService roleService;
    private final RoleMapper roleMapper;

    @PostMapping
    @Operation(summary="Create role")
    public ResponseEntity<RoleResponse> createRole(@Valid @RequestBody CreateRoleRequest request) {
        log.info("\ud83d\udcdd Admin creating role: {}", (Object)request.getName());
        Role role = this.roleService.createRole(request.getName(), request.getDescription(), request.getIsSystem().booleanValue());
        RoleResponse response = this.roleMapper.toResponse(role);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @GetMapping
    @Operation(summary="Get all roles")
    public ResponseEntity<List<RoleResponse>> getAllRoles() {
        List roles = this.roleService.getAllRoles();
        List responses = this.roleMapper.toResponseList(roles);
        return ResponseEntity.ok((Object)responses);
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="Get role by ID")
    public ResponseEntity<RoleResponse> getRoleById(@PathVariable Long id) {
        return this.roleService.getRoleByIdWithPermissions(id).map(arg_0 -> ((RoleMapper)this.roleMapper).toResponse(arg_0)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="Update role")
    public ResponseEntity<RoleResponse> updateRole(@PathVariable Long id, @Valid @RequestBody UpdateRoleRequest request) {
        Role updated = this.roleService.updateRole(id, request.getDescription(), request.getIsActive());
        return ResponseEntity.ok((Object)this.roleMapper.toResponse(updated));
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Delete role")
    public ResponseEntity<Void> deleteRole(@PathVariable Long id) {
        this.roleService.deleteRole(id);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/{roleId}/permissions"})
    @Operation(summary="Assign permissions to role")
    public ResponseEntity<Void> assignPermissions(@PathVariable Long roleId, @Valid @RequestBody AssignPermissionsRequest request) {
        this.roleService.assignPermissionsToRole(roleId, request.getPermissionIds());
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{roleId}/permissions/{permissionId}"})
    @Operation(summary="Remove permission from role")
    public ResponseEntity<Void> removePermission(@PathVariable Long roleId, @PathVariable Long permissionId) {
        this.roleService.removePermissionFromRole(roleId, permissionId);
        return ResponseEntity.ok().build();
    }

    @Generated
    public AdminRoleController(RoleService roleService, RoleMapper roleMapper) {
        this.roleService = roleService;
        this.roleMapper = roleMapper;
    }
}

