/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.service;

import com.saas.admin.dto.AuthResponse;
import com.saas.admin.dto.LoginRequest;
import com.saas.admin.dto.RegisterRequest;
import com.saas.admin.entity.Tenant;
import com.saas.admin.entity.User;
import com.saas.admin.repository.TenantRepository;
import com.saas.admin.repository.UserRepository;
import com.saas.admin.service.TenantSchemaService;
import com.saas.shared.core.TenantContext;
import com.saas.shared.enums.UserType;
import com.saas.shared.exception.BusinessException;
import com.saas.shared.exception.ErrorCode;
import com.saas.shared.security.JwtTokenProvider;
import com.saas.shared.util.SlugUtils;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private JwtTokenProvider tokenProvider;
    @Autowired
    private TenantSchemaService tenantSchemaService;
    @Value(value="${multitenancy.tenant-schema-prefix}")
    private String tenantSchemaPrefix;

    @Transactional
    public AuthResponse register(RegisterRequest request) {
        if (this.userRepository.existsByEmail(request.getEmail())) {
            throw new BusinessException(ErrorCode.USER_ALREADY_EXISTS, "Email already exists");
        }
        String tenantId = UUID.randomUUID().toString();
        String schemaName = SlugUtils.toTenantDatabaseName((String)request.getTenantName(), (String)this.tenantSchemaPrefix);
        if (this.tenantRepository.existsBySchemaName(schemaName)) {
            throw new BusinessException(ErrorCode.TENANT_ALREADY_EXISTS, "Tenant name already exists. Please choose a different name.");
        }
        TenantContext.setTenantId((String)"admin");
        Tenant tenant = new Tenant();
        tenant.setTenantId(tenantId);
        tenant.setTenantName(request.getTenantName());
        tenant.setSchemaName(schemaName);
        this.tenantRepository.save((Object)tenant);
        User user = new User();
        user.setEmail(request.getEmail());
        user.setPassword(this.passwordEncoder.encode((CharSequence)request.getPassword()));
        user.setFirstName(request.getFirstName());
        user.setLastName(request.getLastName());
        user.setUserType(UserType.TENANT_USER);
        user.setTenantId(tenantId);
        user.setRole("ADMIN");
        this.userRepository.save((Object)user);
        this.tenantSchemaService.createTenantDatabaseAndTables(tenant, user);
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)request.getEmail(), (Object)request.getPassword()));
        String token = this.tokenProvider.generateToken(authentication, tenantId, schemaName, UserType.TENANT_USER.name());
        TenantContext.clear();
        return new AuthResponse(token, tenantId, user.getEmail());
    }

    public AuthResponse login(LoginRequest request) {
        String token;
        TenantContext.setTenantId((String)"admin");
        User user = (User)this.userRepository.findByEmail(request.getEmail()).orElseThrow(() -> new BusinessException(ErrorCode.INVALID_CREDENTIALS, "Invalid credentials"));
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)request.getEmail(), (Object)request.getPassword()));
        if (user.getUserType() == UserType.SYSTEM_ADMIN) {
            token = this.tokenProvider.generateToken(authentication, null, null, UserType.SYSTEM_ADMIN.name());
        } else {
            Tenant tenant = (Tenant)this.tenantRepository.findByTenantId(user.getTenantId()).orElseThrow(() -> new BusinessException(ErrorCode.TENANT_NOT_FOUND, "Tenant not found"));
            token = this.tokenProvider.generateToken(authentication, user.getTenantId(), tenant.getSchemaName(), UserType.TENANT_USER.name());
        }
        TenantContext.clear();
        return new AuthResponse(token, user.getTenantId(), user.getEmail());
    }
}

