/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.core;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SchemaMultiTenantConnectionProvider
implements MultiTenantConnectionProvider<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaMultiTenantConnectionProvider.class);
    private final DataSource dataSource;

    public SchemaMultiTenantConnectionProvider(DataSource dataSource) {
        this.dataSource = dataSource;
        log.info("\ud83d\udd27 SchemaMultiTenantConnectionProvider INITIALIZED");
    }

    public Connection getAnyConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void releaseAnyConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public Connection getConnection(String tenantIdentifier) throws SQLException {
        log.info("\ud83d\udd25 getConnection() CALLED with tenantIdentifier: {}", (Object)tenantIdentifier);
        Connection connection = this.getAnyConnection();
        try {
            log.info("\u26a1 Executing: USE {}", (Object)tenantIdentifier);
            connection.createStatement().execute("USE " + tenantIdentifier);
            log.info("\u2705 Successfully switched to database: {}", (Object)tenantIdentifier);
        }
        catch (SQLException e) {
            log.error("\u274c FAILED to switch to database {}: {}", (Object)tenantIdentifier, (Object)e.getMessage());
            throw new SQLException("Could not switch to database " + tenantIdentifier, e);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(String tenantIdentifier, Connection connection) throws SQLException {
        try {
            connection.createStatement().execute("USE saas_db");
        }
        catch (SQLException sQLException) {
        }
        finally {
            connection.close();
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return false;
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return null;
    }
}

