/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.shared.enums.Provider;
import com.saas.tenant.entity.InboundCallData;
import com.saas.tenant.entity.InboundCallRequest;
import com.saas.tenant.service.InboundCallService;
import com.saas.voip.service.TwilioCostService;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voip/twilio"})
public class TwilioStatusCallbackController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwilioStatusCallbackController.class);
    private final TwilioCostService twilioCostService;
    private final InboundCallService inboundCallService;
    private final PhoneNumberRepository phoneNumberRepository;
    private final TenantRepository tenantRepository;
    private final ObjectMapper objectMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/status-callback"}, produces={"application/xml"})
    public String handleStatusCallback(HttpServletRequest request) {
        block22: {
            log.info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            log.info("\u2551     TWILIO STATUS CALLBACK WEBHOOK RECEIVED          \u2551");
            log.info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
            log.info("\ud83c\udf10 [TwilioStatusCallback] Request URL: {}", (Object)request.getRequestURL());
            log.info("\ud83c\udf10 [TwilioStatusCallback] Request Method: {}", (Object)request.getMethod());
            log.info("\ud83c\udf10 [TwilioStatusCallback] Content-Type: {}", (Object)request.getContentType());
            MultiValueMap formData = this.extractFormData(request);
            log.info("\ud83d\udce6 [TwilioStatusCallback] Extracted {} form parameters", (Object)formData.size());
            String callSid = (String)formData.getFirst((Object)"CallSid");
            String callStatus = (String)formData.getFirst((Object)"CallStatus");
            String callDuration = (String)formData.getFirst((Object)"CallDuration");
            String priceString = (String)formData.getFirst((Object)"Price");
            String priceUnit = (String)formData.getFirst((Object)"PriceUnit");
            String from = (String)formData.getFirst((Object)"From");
            String to = (String)formData.getFirst((Object)"To");
            String timestamp = (String)formData.getFirst((Object)"Timestamp");
            String direction = (String)formData.getFirst((Object)"Direction");
            log.info("\ud83c\udfaf [TwilioStatusCallback] Parsed webhook data:");
            log.info("   \u251c\u2500 CallSid: {}", (Object)callSid);
            log.info("   \u251c\u2500 CallStatus: {}", (Object)callStatus);
            log.info("   \u251c\u2500 Duration: {}s", (Object)callDuration);
            log.info("   \u251c\u2500 Price: {} {}", (Object)priceString, (Object)priceUnit);
            log.info("   \u251c\u2500 From: {}", (Object)from);
            log.info("   \u251c\u2500 To: {}", (Object)to);
            log.info("   \u251c\u2500 Direction: {}", (Object)direction);
            log.info("   \u2514\u2500 Timestamp: {}", (Object)timestamp);
            if (log.isDebugEnabled()) {
                log.debug("\ud83d\udccb [TwilioStatusCallback] All webhook parameters:");
                formData.forEach((key, values) -> log.debug("   \u251c\u2500 {}: {}", key, values.get(0)));
            }
            if ("completed".equals(callStatus)) {
                block21: {
                    log.info("\u2705 [TwilioStatusCallback] Call status is 'completed' - processing call cost...");
                    try {
                        String tenantId;
                        Optional tenantOpt;
                        log.info("\ud83d\udce5 [TwilioStatusCallback] Retrieving conversation for CallSid: {}", (Object)callSid);
                        Optional phoneOpt = this.phoneNumberRepository.findByPhoneNumber(to);
                        if (!phoneOpt.isPresent() || ((PhoneNumber)phoneOpt.get()).getProvider() != Provider.TWILIO || !(tenantOpt = this.tenantRepository.findByTenantId(tenantId = ((PhoneNumber)phoneOpt.get()).getTenantId())).isPresent()) break block21;
                        String schemaName = ((Tenant)tenantOpt.get()).getSchemaName();
                        TenantContext.setTenantId((String)schemaName);
                        try {
                            Optional requestOpt = this.inboundCallService.getPatientRequestByCallSid(callSid);
                            if (requestOpt.isPresent()) {
                                InboundCallRequest patientRequest = (InboundCallRequest)requestOpt.get();
                                if (patientRequest.getNom() != null || patientRequest.getTelephone() != null) {
                                    log.info("\u2705 [TwilioStatusCallback] Patient data found: Name={}, Phone={}, Doctor={}, Appointment={}", new Object[]{patientRequest.getNom(), patientRequest.getTelephone(), patientRequest.getDoctorName(), patientRequest.getAppointmentDateTime()});
                                } else {
                                    log.info("\u2139\ufe0f [TwilioStatusCallback] No patient data extracted (patient may not have provided info)");
                                }
                                String conversationJson = patientRequest.getConversationTranscript();
                                if (conversationJson != null) {
                                    List conversation = (List)this.objectMapper.readValue(conversationJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                                    Optional callDataOpt = this.inboundCallService.getCallByCallSid(callSid);
                                    if (callDataOpt.isPresent()) {
                                        InboundCallData callData = (InboundCallData)callDataOpt.get();
                                        callData.setConversation(conversation);
                                        callData.setDuration(callDuration != null ? Integer.valueOf(Integer.parseInt(callDuration)) : null);
                                        this.inboundCallService.saveInBothDatabases(callData, tenantId, schemaName);
                                        log.info("\u2705 [TwilioStatusCallback] Conversation stored in InboundCallData ({} messages)", (Object)conversation.size());
                                    } else {
                                        log.warn("\u26a0\ufe0f [TwilioStatusCallback] No InboundCallData found for CallSid: {}", (Object)callSid);
                                    }
                                } else {
                                    log.info("\u23ed\ufe0f [TwilioStatusCallback] No conversation transcript available yet for CallSid: {}", (Object)callSid);
                                }
                            } else {
                                log.info("\u23ed\ufe0f [TwilioStatusCallback] No InboundCallRequest found for CallSid: {}", (Object)callSid);
                            }
                        }
                        finally {
                            TenantContext.clear();
                        }
                    }
                    catch (Exception convEx) {
                        log.error("\u274c [TwilioStatusCallback] Failed to store conversation", (Throwable)convEx);
                    }
                }
                try {
                    log.info("\ud83d\ude80 [TwilioStatusCallback] Attempting to fetch cost from Twilio API...");
                    log.info("\ud83d\ude80 [TwilioStatusCallback] Calling TwilioCostService.fetchAndSaveCallCost()...");
                    this.twilioCostService.fetchAndSaveCallCost(callSid, from, to);
                    log.info("\u2705 [TwilioStatusCallback] Twilio API call cost retrieval initiated successfully!");
                    log.info("   \u251c\u2500 CallSid: {}", (Object)callSid);
                    log.info("   \u2514\u2500 Method: Twilio API (preferred)");
                }
                catch (Exception e) {
                    log.error("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
                    log.error("\u2551     TWILIO API COST FETCH FAILED                     \u2551");
                    log.error("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                    log.error("\u274c [TwilioStatusCallback] EXCEPTION while fetching Twilio call cost!", (Throwable)e);
                    log.error("\u274c [TwilioStatusCallback] Exception type: {}", (Object)e.getClass().getName());
                    log.error("\u274c [TwilioStatusCallback] Exception message: {}", (Object)e.getMessage());
                    if (priceString != null && !priceString.isEmpty()) {
                        log.warn("\u26a0\ufe0f [TwilioStatusCallback] \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                        log.warn("\u26a0\ufe0f [TwilioStatusCallback] API FAILED - USING WEBHOOK FALLBACK");
                        log.warn("\u26a0\ufe0f [TwilioStatusCallback] \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                        log.info("\ud83d\udce5 [TwilioStatusCallback] Webhook price data available:");
                        log.info("   \u251c\u2500 Price: {}", (Object)priceString);
                        log.info("   \u251c\u2500 Currency: {}", (Object)priceUnit);
                        log.info("   \u2514\u2500 Duration: {}s", (Object)callDuration);
                        try {
                            log.info("\ud83d\udcbe [TwilioStatusCallback] Saving cost from webhook data...");
                            this.twilioCostService.saveCallCostFromWebhook(callSid, priceString, priceUnit, callDuration, timestamp, from, to);
                            log.info("\u2705 [TwilioStatusCallback] Call cost saved from webhook data successfully!");
                            log.info("   \u251c\u2500 CallSid: {}", (Object)callSid);
                            log.info("   \u251c\u2500 Method: Webhook fallback");
                            log.info("   \u2514\u2500 Reason: Twilio API unavailable (likely Test Account)");
                        }
                        catch (Exception webhookEx) {
                            log.error("\u274c [TwilioStatusCallback] WEBHOOK FALLBACK ALSO FAILED!", (Throwable)webhookEx);
                            log.error("\u274c [TwilioStatusCallback] Exception type: {}", (Object)webhookEx.getClass().getName());
                            log.error("\u274c [TwilioStatusCallback] Exception message: {}", (Object)webhookEx.getMessage());
                        }
                        break block22;
                    }
                    log.error("\u274c [TwilioStatusCallback] No webhook price data available!");
                    log.error("\u274c [TwilioStatusCallback] Cannot save call cost - both API and webhook failed");
                    log.error("\u274c [TwilioStatusCallback] Recommendations:");
                    log.error("   \u251c\u2500 Verify Twilio account status (Test vs Live)");
                    log.error("   \u251c\u2500 Check that webhook includes Price and PriceUnit");
                    log.error("   \u2514\u2500 Review Twilio webhook configuration");
                }
            } else {
                log.info("\u23ed\ufe0f [TwilioStatusCallback] Call status is '{}' (not 'completed') - skipping cost fetch", (Object)callStatus);
                log.info("\u23ed\ufe0f [TwilioStatusCallback] Cost tracking only occurs for completed calls");
            }
        }
        log.info("\u2705 [TwilioStatusCallback] Webhook processing complete - returning TwiML response");
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Response></Response>";
    }

    private MultiValueMap<String, String> extractFormData(HttpServletRequest request) {
        log.debug("\ud83d\udce4 [TwilioStatusCallback] Extracting form data from request");
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        try {
            String line;
            BufferedReader reader = request.getReader();
            StringBuilder body = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                body.append(line);
            }
            log.debug("\ud83d\udcc4 [TwilioStatusCallback] Raw request body: {}", (Object)body.toString());
            String[] pairs = body.toString().split("&");
            log.debug("\ud83d\udccb [TwilioStatusCallback] Parsing {} key-value pairs", (Object)pairs.length);
            String[] stringArray = pairs;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String pair = stringArray[i];
                String[] keyValue = pair.split("=", 2);
                if (keyValue.length != 2) continue;
                String key = URLDecoder.decode(keyValue[0], "UTF-8");
                String value = URLDecoder.decode(keyValue[1], "UTF-8");
                formData.add((Object)key, (Object)value);
                log.debug("   \u251c\u2500 {} = {}", (Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            log.error("\u274c [TwilioStatusCallback] Error reading request body", (Throwable)e);
            log.error("\u274c [TwilioStatusCallback] Exception type: {}", (Object)e.getClass().getName());
            log.error("\u274c [TwilioStatusCallback] Exception message: {}", (Object)e.getMessage());
        }
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String[] paramValues;
            String paramName = (String)paramNames.nextElement();
            for (String paramValue : paramValues = request.getParameterValues(paramName)) {
                if (formData.containsKey((Object)paramName)) continue;
                formData.add((Object)paramName, (Object)paramValue);
                log.debug("   \u251c\u2500 {} = {} (from URL params)", (Object)paramName, (Object)paramValue);
            }
        }
        log.debug("\u2705 [TwilioStatusCallback] Form data extraction complete - {} parameters", (Object)formData.size());
        return formData;
    }

    @Generated
    public TwilioStatusCallbackController(TwilioCostService twilioCostService, InboundCallService inboundCallService, PhoneNumberRepository phoneNumberRepository, TenantRepository tenantRepository, ObjectMapper objectMapper) {
        this.twilioCostService = twilioCostService;
        this.inboundCallService = inboundCallService;
        this.phoneNumberRepository = phoneNumberRepository;
        this.tenantRepository = tenantRepository;
        this.objectMapper = objectMapper;
    }
}

