Passing Variables to AI Assistants from TeXML

To pass variables from your TeXML application to an AI Assistant, consider the following methods:

1. Direct XML Syntax (Recommended for TeXML)
Utilize the <DynamicVariables> element within your TeXML XML response:

xml


<Response>
  <Connect>
    <AI>
      <Assistant model="openai/gpt-4" api_key_ref="my_key_ref" 
                 instructions="You are a helpful assistant for {{full_name}} at {{facility_name}}.">
        <DynamicVariables>
          <Variable name="full_name" value="James Smith"/>
          <Variable name="facility_name" value="Cleveland Clinic Main Campus"/>
          <Variable name="facility_department" value="Emergency Department"/>
        </DynamicVariables>
        <Tools>
          <!-- Your tools configuration -->
        </Tools>
      </Assistant>
    </AI>
  </Connect>
</Response>
Variables can be referenced in your assistant's instructions using the {{variable_name}} syntax.

2. API Call with Dynamic Variables
Include variables in the request when initiating an outbound call via the API:

bash


curl --request POST \
  --url https://api.telnyx.com/v2/texml/calls/<texml_app_id> \
  --header "Authorization: Bearer $TELNYX_API_KEY" \
  --header 'Content-Type: application/json' \
  --data '{
    "From": "+1234567890",
    "To": "+1987654321",
    "AIAssistantDynamicVariables": {
      "full_name": "James Smith",
      "facility_name": "Cleveland Clinic Main Campus",
      "facility_department": "Emergency Department"
    }
  }'
3. Custom SIP Headers
For inbound calls, use custom SIP headers with the X- prefix:

X-Full-Name → resolves to {{full_name}}
X-Customer-ID → resolves to {{customer_id}}
X-Account-Type → resolves to {{account_type}}
These headers map to dynamic variables in your AI Assistant.

4. Dynamic Variables Webhook
Configure a dynamic_variables_webhook_url in your AI Assistant settings. Telnyx will send a POST request with system variables, and you can respond with custom variables:

Webhook Request (from Telnyx):

json


{
  "call_id": "abc123",
  "from": "+1234567890",
  "to": "+1987654321"
}
Your Response:

json


{
  "full_name": "James Smith",
  "account_balance": "150.00",
  "last_order_date": "2025-10-15"
}
5. Default Variables
Set default values in the AI Assistant builder as fallbacks when variables aren't provided through other methods.

Variable Priority Order
Variables are resolved in this order (highest to lowest priority):

API call parameters (AIAssistantDynamicVariables)
Custom SIP headers (X- prefix)
Dynamic variables webhook response
Default values set in Assistant builder
Unset (remains as {{variable_name}})
Key Documentation
Dynamic Variables Documentation↗
TeXML Verbs Documentation↗
Best Practices
Use descriptive variable names (e.g., customer_name instead of name)
Always set default values for critical variables
Test variable substitution before production deployment
Use the webhook method for dynamic data that changes frequently
Keep variable values concise to avoid token limits in AI prompts
For further implementation details, refer to the provided documentation links.