package com.saas.admin.dto.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;

/**
 * Response DTO for Role
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RoleResponse {
    private Long id;
    private String name;
    private String description;
    private Boolean isActive;
    private Boolean isSystem;
    private List<String> permissions; // Permission strings like "tenant:read"
    private LocalDateTime createdAt;
    private LocalDateTime updatedAt;
}
