package com.saas.admin.repository;

import com.saas.admin.entity.AdminInboundCallData;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface AdminInboundCallDataRepository extends JpaRepository<AdminInboundCallData, Long> {
    
    Optional<AdminInboundCallData> findByCallSid(String callSid);
    
    List<AdminInboundCallData> findByTenantId(String tenantId);
    
    List<AdminInboundCallData> findByTenantIdAndProvider(String tenantId, String provider);
    
    List<AdminInboundCallData> findByProvider(String provider);
}
