package com.saas.shared.dto.mapper;

import com.saas.admin.dto.request.CreateTenantRequest;
import com.saas.admin.dto.response.TenantResponse;
import com.saas.admin.entity.Tenant;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.List;

@Mapper(componentModel = "spring")
public interface TenantMapper {
    
    TenantResponse toResponse(Tenant tenant);
    
    List<TenantResponse> toResponseList(List<Tenant> tenants);
    
    @Mapping(target = "tenantId", ignore = true)
    @Mapping(target = "schemaName", ignore = true)
    @Mapping(target = "createdAt", ignore = true)
    @Mapping(target = "updatedAt", ignore = true)
    Tenant toEntity(CreateTenantRequest request);
}
