package com.saas.tenant.entity;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.type.SqlTypes;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

@Entity
@Table(name = "call_cost_records")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CallCostRecord {
    
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    
    @Column(name = "call_sid", nullable = false, unique = true)
    private String callSid;
    
    @Column(name = "provider", nullable = false)
    private String provider; // TWILIO, ELEVENLABS, TELNYX, ZIWO
    
    @Column(name = "call_duration_seconds")
    private Integer callDurationSeconds;
    
    @Column(name = "cost", precision = 10, scale = 6)
    private BigDecimal cost; // Cost in the specified currency
    
    @Column(name = "currency", length = 3)
    private String currency; // USD, EUR, etc.
    
    @JdbcTypeCode(SqlTypes.JSON)
    @Column(name = "cost_details", columnDefinition = "JSON")
    private Map<String, Object> costDetails; // Detailed breakdown (STT, TTS, LLM, etc.)
    
    @Column(name = "call_start_time")
    private LocalDateTime callStartTime;
    
    @Column(name = "call_end_time")
    private LocalDateTime callEndTime;
    
    @Column(name = "from_number")
    private String fromNumber;
    
    @Column(name = "to_number")
    private String toNumber;
    
    @Column(name = "created_at", nullable = false, updatable = false)
    private LocalDateTime createdAt;
    
    @Column(name = "updated_at")
    private LocalDateTime updatedAt;
    
    @PrePersist
    protected void onCreate() {
        createdAt = LocalDateTime.now();
        updatedAt = LocalDateTime.now();
    }
    
    @PreUpdate
    protected void onUpdate() {
        updatedAt = LocalDateTime.now();
    }
}
