package com.saas.voip.config;

import com.saas.voip.handler.TwilioMediaStreamHandler;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
@EnableWebSocket
@RequiredArgsConstructor
@Slf4j
public class WebSocketConfig implements WebSocketConfigurer {

    private final TwilioMediaStreamHandler twilioMediaStreamHandler;

    @Override
    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        log.info("Registering WebSocket handler at /media-stream");
        registry.addHandler(twilioMediaStreamHandler, "/media-stream")
                .setAllowedOrigins("*")
                .setAllowedOriginPatterns("*");
    }
}
