package com.saas.voip.handler;

import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.TextMessage;

import java.util.Map;

public interface AiSessionHandler {
    
    void onClientConnect(WebSocketSession session, String streamSid, String callSid, String fromNumber, String toNumber) throws Exception;
    
    void onMediaFrame(WebSocketSession session, String payload) throws Exception;
    
    void onMark(WebSocketSession session, Map<String, Object> markData) throws Exception;
    
    void onClose(WebSocketSession session) throws Exception;
    
    boolean supportsStructuredExtraction();
    
    Map<String, Object> buildStructuredPayload(String transcript);
}
