<?php ($newDiscountedPrice = $newDiscountedPrice ?? 0); ?>

<div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
    'w-full rounded-3xl border bg-background',
    'shadow-[0_7px_20px_rgba(0,0,0,0.04)]' => $plan->is_featured,
]); ?>">
    <div class="flex h-full flex-col p-7">

        <h2 class="mb-5 flex items-start leading-none text-heading-foreground">
            <?php echo app('translator')->get('Order Summary'); ?>
        </h2>
        <div class="inline-flex flex-col items-start gap-2">
            <p class="mb-0 mt-1 flex items-start leading-none text-heading-foreground">
                <?php echo e(__($plan->name)); ?> / <?php echo e($plan->type == 'prepaid' ? __('One time') : __(formatCamelCase($plan->frequency))); ?> <?php echo app('translator')->get('Plan'); ?>
            </p>
            <?php if($plan->is_featured == 1): ?>
                <div class="inline-flex rounded-full bg-gradient-to-r from-[#ece7f7] via-[#e7c5e6] to-[#e7ebf9] px-3 py-1 text-3xs text-black">
                    <?php echo e(__('Popular plan')); ?>

                </div>
            <?php endif; ?>
        </div>

        <ul class="list-unstyled mt-5 w-full rounded-lg border p-4">
            <li class="flex px-1">
                <p class="grow text-start"><?php echo e(__('Subtotal')); ?></p>
                <p class="whitespace-nowrap text-end"><?php echo displayCurr(currency()->symbol, $plan->price, 0, null); ?></p>
            </li>
            <?php if($plan->price - $newDiscountedPrice > 0): ?>
                <hr class="mt-0">
                <li class="flex px-1">
                    <div class="flex grow text-start">
                        <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tabler-tag'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'me-1 size-5 -scale-x-100 pt-[0.15rem]']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
                        <p><?php echo e(__('Discount')); ?></p> <?php echo displayDiscountOrCouponName($plan); ?>

                    </div>
                    <p class="whitespace-nowrap text-end text-red-600">- <?php echo displayCurr(currency()->symbol, $plan->price - $newDiscountedPrice, null); ?></p>
                </li>
            <?php endif; ?>
            <hr class="mt-0">
            <li class="flex px-1">
                <p class="grow text-start"><?php echo e(__('Tax')); ?> (<?php echo e($taxRate ?? 0); ?>% VAT)</p>
                <p class="whitespace-nowrap text-end"><?php echo displayCurr(currency()->symbol, $taxValue ?? null, tax_included: $plan->price_tax_included); ?></p>
            </li>
            <hr class="mt-0">
            <li class="flex px-1">
                <p class="grow text-start"><?php echo e(__('Total')); ?></p>
                <p class="whitespace-nowrap text-end"><?php echo displayCurr(currency()->symbol, $plan->price, $taxValue ?? 0, $newDiscountedPrice ?? null, tax_included: $plan->price_tax_included); ?></p>
            </li>
        </ul>

        <?php if (isset($component)) { $__componentOriginal108762a00a61bbda2e149b49ad544dca = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal108762a00a61bbda2e149b49ad544dca = $attributes; } ?>
<?php $component = App\View\Components\PlanDetailsCard::resolve(['plan' => $plan,'period' => $plan->frequency] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('plan-details-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\PlanDetailsCard::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal108762a00a61bbda2e149b49ad544dca)): ?>
<?php $attributes = $__attributesOriginal108762a00a61bbda2e149b49ad544dca; ?>
<?php unset($__attributesOriginal108762a00a61bbda2e149b49ad544dca); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal108762a00a61bbda2e149b49ad544dca)): ?>
<?php $component = $__componentOriginal108762a00a61bbda2e149b49ad544dca; ?>
<?php unset($__componentOriginal108762a00a61bbda2e149b49ad544dca); ?>
<?php endif; ?>

        <div class="mt-7 text-center">
            <a
                class="btn w-full rounded-md p-[1.15em_2.1em] text-[15px] group-[.theme-dark]/body:!bg-[rgba(255,255,255,1)] group-[.theme-dark]/body:!text-[rgba(0,0,0,0.9)]"
                href="<?php echo e(auth()->check() ? route('dashboard.user.payment.subscription') : route('index') . '#pricing'); ?>"
            ><?php echo e(__('Change Plan')); ?></a>
        </div>
    </div>
</div>
<?php /**PATH /home/withanouar/public_html/solvamind.ai/resources/views/default/panel/user/finance/partials/plan_card.blade.php ENDPATH**/ ?>