/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.entity;

import com.saas.admin.entity.Role;
import com.saas.admin.entity.User;
import com.saas.admin.entity.UserRole;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name="user_roles", schema="saas_db", uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "role_id"})})
public class UserRole {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private User user;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="role_id", nullable=false)
    private Role role;
    @CreationTimestamp
    @Column(nullable=false, updatable=false)
    private LocalDateTime assignedAt;
    @Column(name="assigned_by")
    private String assignedBy;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserRole)) {
            return false;
        }
        UserRole that = (UserRole)o;
        return this.user.getId().equals(that.user.getId()) && this.role.getId().equals(that.role.getId());
    }

    public int hashCode() {
        return Objects.hash(this.user.getId(), this.role.getId());
    }

    @Generated
    public static UserRoleBuilder builder() {
        return new UserRoleBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public Role getRole() {
        return this.role;
    }

    @Generated
    public LocalDateTime getAssignedAt() {
        return this.assignedAt;
    }

    @Generated
    public String getAssignedBy() {
        return this.assignedBy;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setUser(User user) {
        this.user = user;
    }

    @Generated
    public void setRole(Role role) {
        this.role = role;
    }

    @Generated
    public void setAssignedAt(LocalDateTime assignedAt) {
        this.assignedAt = assignedAt;
    }

    @Generated
    public void setAssignedBy(String assignedBy) {
        this.assignedBy = assignedBy;
    }

    @Generated
    public String toString() {
        return "UserRole(id=" + this.getId() + ", user=" + String.valueOf(this.getUser()) + ", role=" + String.valueOf(this.getRole()) + ", assignedAt=" + String.valueOf(this.getAssignedAt()) + ", assignedBy=" + this.getAssignedBy() + ")";
    }

    @Generated
    public UserRole() {
    }

    @Generated
    public UserRole(Long id, User user, Role role, LocalDateTime assignedAt, String assignedBy) {
        this.id = id;
        this.user = user;
        this.role = role;
        this.assignedAt = assignedAt;
        this.assignedBy = assignedBy;
    }
}

