/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.service;

import com.saas.admin.entity.Tenant;
import com.saas.admin.entity.User;
import com.saas.admin.service.TenantSchemaMigrationService;
import com.saas.shared.core.TenantContext;
import com.saas.tenant.entity.TenantInfo;
import com.saas.tenant.entity.TenantUser;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManagerFactory;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import lombok.Generated;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Service;

@Service
public class TenantSchemaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantSchemaService.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private EntityManagerFactory entityManagerFactory;
    @Autowired
    private TenantSchemaMigrationService migrationService;
    @Value(value="${multitenancy.tenant-schema-prefix}")
    private String tenantSchemaPrefix;

    public void createTenantDatabaseAndTables(Tenant tenant, User adminUser) {
        String databaseName = tenant.getSchemaName();
        try {
            log.info("Creating tenant database: {}", (Object)databaseName);
            this.createDatabase(databaseName);
            log.info("Creating tables and copying data to tenant database...");
            this.createTablesAndCopyData(databaseName, tenant, adminUser);
            log.info("Recording initial schema version for tenant database...");
            this.migrationService.recordInitialVersion(databaseName);
            log.info("Tenant database setup completed successfully for: {}", (Object)databaseName);
        }
        catch (Exception e) {
            log.error("Failed to create tenant database: {}", (Object)databaseName, (Object)e);
            throw new RuntimeException("Failed to create tenant database", e);
        }
    }

    private void createDatabase(String databaseName) {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            String createDbSQL = String.format("CREATE DATABASE IF NOT EXISTS `%s`", databaseName);
            statement.execute(createDbSQL);
            log.info("Database '{}' created successfully", (Object)databaseName);
        }
        catch (Exception e) {
            log.error("Failed to create database: {}", (Object)databaseName, (Object)e);
            throw new RuntimeException("Database creation failed", e);
        }
    }

    private void createTablesAndCopyData(String databaseName, Tenant tenant, User adminUser) {
        SessionFactory sessionFactory;
        StandardServiceRegistry serviceRegistry;
        block11: {
            TenantContext.setTenantId((String)databaseName);
            serviceRegistry = null;
            sessionFactory = null;
            Session session = null;
            Transaction transaction = null;
            try {
                log.info("Building Hibernate metadata for tenant entities...");
                HashMap<String, Object> settings = new HashMap<String, Object>();
                settings.put("hibernate.connection.datasource", this.dataSource);
                settings.put("hibernate.dialect", "org.hibernate.dialect.MySQLDialect");
                settings.put("hibernate.default_catalog", databaseName);
                settings.put("hibernate.hbm2ddl.auto", "create");
                settings.put("hibernate.physical_naming_strategy", "org.hibernate.boot.model.naming.CamelCaseToUnderscoresNamingStrategy");
                serviceRegistry = new StandardServiceRegistryBuilder().applySettings(settings).build();
                MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
                Set tenantEntities = this.scanTenantEntities();
                log.info("Found {} tenant entities to create tables for", (Object)tenantEntities.size());
                for (Class entityClass : tenantEntities) {
                    log.info("Adding entity class: {}", (Object)entityClass.getSimpleName());
                    metadataSources.addAnnotatedClass(entityClass);
                }
                log.info("Creating tables in tenant database '{}' using Hibernate...", (Object)databaseName);
                Metadata metadata = metadataSources.buildMetadata();
                sessionFactory = metadata.buildSessionFactory();
                log.info("Tables created successfully, now copying data...");
                session = sessionFactory.openSession();
                transaction = session.beginTransaction();
                TenantInfo tenantInfo = new TenantInfo();
                tenantInfo.setTenantId(tenant.getTenantId());
                tenantInfo.setTenantName(tenant.getTenantName());
                tenantInfo.setStatus(tenant.getStatus());
                tenantInfo.setCreatedAt(tenant.getCreatedAt());
                tenantInfo.setUpdatedAt(tenant.getUpdatedAt());
                session.persist((Object)tenantInfo);
                log.info("Tenant info copied to tenant database");
                TenantUser tenantUser = new TenantUser();
                tenantUser.setEmail(adminUser.getEmail());
                tenantUser.setFirstName(adminUser.getFirstName());
                tenantUser.setLastName(adminUser.getLastName());
                tenantUser.setPassword(adminUser.getPassword());
                tenantUser.setStatus("ACTIVE");
                session.persist((Object)tenantUser);
                log.info("Admin user copied to tenant database");
                transaction.commit();
                log.info("Data copied successfully to tenant database: {}", (Object)databaseName);
                if (session == null) break block11;
            }
            catch (Exception e) {
                try {
                    if (transaction != null && transaction.isActive()) {
                        transaction.rollback();
                    }
                    log.error("Failed to create tables or copy data", (Throwable)e);
                    throw new RuntimeException("Tenant setup failed", e);
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    if (sessionFactory != null) {
                        sessionFactory.close();
                    }
                    if (serviceRegistry != null) {
                        StandardServiceRegistryBuilder.destroy(serviceRegistry);
                    }
                    TenantContext.clear();
                    throw throwable;
                }
            }
            session.close();
        }
        if (sessionFactory != null) {
            sessionFactory.close();
        }
        if (serviceRegistry != null) {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)serviceRegistry);
        }
        TenantContext.clear();
    }

    private Set<Class<?>> scanTenantEntities() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        HashSet entityClasses = new HashSet();
        String basePackage = "com.saas.tenant.entity";
        try {
            Set candidates = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition bd : candidates) {
                try {
                    Class<?> clazz = Class.forName(bd.getBeanClassName());
                    entityClasses.add(clazz);
                    log.debug("Discovered tenant entity: {}", (Object)clazz.getSimpleName());
                }
                catch (ClassNotFoundException e) {
                    log.error("Could not load entity class: {}", (Object)bd.getBeanClassName(), (Object)e);
                }
            }
            log.info("Successfully scanned {} tenant entities from package: {}", (Object)entityClasses.size(), (Object)basePackage);
        }
        catch (Exception e) {
            log.error("Error scanning tenant entities from package: {}", (Object)basePackage, (Object)e);
            throw new RuntimeException("Failed to scan tenant entities", e);
        }
        return entityClasses;
    }
}

