/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.audit;

import com.saas.shared.audit.AuditService;
import com.saas.shared.audit.Auditable;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class AuditAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditAspect.class);
    private final AuditService auditService;

    @Around(value="@annotation(auditable)")
    public Object audit(ProceedingJoinPoint joinPoint, Auditable auditable) throws Throwable {
        Object result = joinPoint.proceed();
        try {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            String userId = auth != null && auth.isAuthenticated() ? auth.getName() : "ANONYMOUS";
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = attributes != null ? attributes.getRequest() : null;
            String entityId = this.extractEntityId(result);
            this.auditService.log(userId, null, auditable.action(), auditable.entityType(), entityId, result, request);
        }
        catch (Exception e) {
            log.error("Failed to create audit log", (Throwable)e);
        }
        return result;
    }

    private String extractEntityId(Object result) {
        if (result == null) {
            return null;
        }
        try {
            if (result.getClass().getMethod("getId", new Class[0]) != null) {
                Object id = result.getClass().getMethod("getId", new Class[0]).invoke(result, new Object[0]);
                return id != null ? id.toString() : null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Generated
    public AuditAspect(AuditService auditService) {
        this.auditService = auditService;
    }
}

