/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.security;

import com.saas.admin.entity.User;
import com.saas.admin.repository.UserRepository;
import com.saas.admin.repository.UserRoleRepository;
import com.saas.shared.security.UserPrincipal;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class CustomUserDetailsService
implements UserDetailsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomUserDetailsService.class);
    private final UserRepository userRepository;
    private final UserRoleRepository userRoleRepository;

    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        User user = (User)this.userRepository.findByEmail(email).orElseThrow(() -> new UsernameNotFoundException("User not found with email: " + email));
        List permissions = this.userRoleRepository.findAllPermissionsByUserId(user.getId());
        log.debug("\ud83d\udd10 Loading user: {} with {} permissions", (Object)email, (Object)permissions.size());
        return new UserPrincipal(user.getId(), user.getEmail(), user.getPassword(), user.getRole(), user.getUserType(), permissions);
    }

    public UserDetails loadUserById(Long id) {
        User user = (User)this.userRepository.findById((Object)id).orElseThrow(() -> new UsernameNotFoundException("User not found with id: " + id));
        List permissions = this.userRoleRepository.findAllPermissionsByUserId(id);
        log.debug("\ud83d\udd10 Loading user ID: {} with {} permissions", (Object)id, (Object)permissions.size());
        return new UserPrincipal(user.getId(), user.getEmail(), user.getPassword(), user.getRole(), user.getUserType(), permissions);
    }

    @Generated
    public CustomUserDetailsService(UserRepository userRepository, UserRoleRepository userRoleRepository) {
        this.userRepository = userRepository;
        this.userRoleRepository = userRoleRepository;
    }
}

