/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.service;

import com.saas.shared.core.TenantContext;
import com.saas.tenant.entity.InboundCallData;
import com.saas.tenant.repository.InboundCallDataRepository;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DualSaveCallDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DualSaveCallDataService.class);
    private final InboundCallDataRepository callDataRepository;

    public void saveToBothDatabases(InboundCallData callData, String tenantSchema) {
        log.info("\ud83d\ude80 [DualSaveCallDataService] saveToBothDatabases() CALLED");
        log.info("\ud83d\ude80 [DualSaveCallDataService] CallSid: {}, Provider: {}, TenantSchema: {}", new Object[]{callData.getCallSid(), callData.getProvider(), tenantSchema});
        this.saveToAdminDatabase(callData);
        this.saveToTenantDatabase(callData, tenantSchema);
        log.info("\u2705 [DualSaveCallDataService] Dual save completed for CallSid: {}", (Object)callData.getCallSid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    protected void saveToAdminDatabase(InboundCallData callData) {
        log.info("\ud83d\udcbe [DualSaveCallDataService] saveToAdminDatabase() START - CallSid: {}", (Object)callData.getCallSid());
        try {
            log.info("\ud83c\udfaf [DualSaveCallDataService] Setting TenantContext to 'saas_db'");
            TenantContext.setTenantId((String)"saas_db");
            InboundCallData adminCopy = this.cloneCallData(callData);
            log.info("\ud83d\udccb [DualSaveCallDataService] Cloned call data - CallSid: {}, Provider: {}", (Object)adminCopy.getCallSid(), (Object)adminCopy.getProvider());
            log.info("\ud83d\udcbe [DualSaveCallDataService] Calling repository.save() for ADMIN database...");
            InboundCallData saved = (InboundCallData)this.callDataRepository.save((Object)adminCopy);
            log.info("\u2705 [DualSaveCallDataService] Call data saved to ADMIN database (saas_db)!");
            log.info("\u2705 [DualSaveCallDataService] Saved ID: {}, CallSid: {}, Provider: {}", new Object[]{saved.getId(), saved.getCallSid(), saved.getProvider()});
        }
        catch (Exception e) {
            log.error("\u274c [DualSaveCallDataService] EXCEPTION saving to ADMIN database!", (Throwable)e);
            log.error("\u274c [DualSaveCallDataService] Exception type: {}, Message: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            log.error("\u274c [DualSaveCallDataService] CallSid: {}", (Object)callData.getCallSid());
        }
        finally {
            TenantContext.clear();
            log.info("\ud83e\uddf9 [DualSaveCallDataService] TenantContext cleared after ADMIN save");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    protected void saveToTenantDatabase(InboundCallData callData, String tenantSchema) {
        log.info("\ud83d\udcbe [DualSaveCallDataService] saveToTenantDatabase() START - CallSid: {}, Schema: {}", (Object)callData.getCallSid(), (Object)tenantSchema);
        try {
            log.info("\ud83c\udfaf [DualSaveCallDataService] Setting TenantContext to '{}'", (Object)tenantSchema);
            TenantContext.setTenantId((String)tenantSchema);
            log.info("\ud83d\udcdd [DualSaveCallDataService] Call data details - Provider: {}, From: {}, To: {}", new Object[]{callData.getProvider(), callData.getFromNumber(), callData.getToNumber()});
            log.info("\ud83d\udcbe [DualSaveCallDataService] Calling repository.save() for TENANT database...");
            InboundCallData saved = (InboundCallData)this.callDataRepository.save((Object)callData);
            log.info("\u2705 [DualSaveCallDataService] Call data saved to TENANT database ({})!", (Object)tenantSchema);
            log.info("\u2705 [DualSaveCallDataService] Saved ID: {}, CallSid: {}, Provider: {}", new Object[]{saved.getId(), saved.getCallSid(), saved.getProvider()});
        }
        catch (Exception e) {
            log.error("\u274c [DualSaveCallDataService] EXCEPTION saving to TENANT database '{}'!", (Object)tenantSchema, (Object)e);
            log.error("\u274c [DualSaveCallDataService] Exception type: {}, Message: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            log.error("\u274c [DualSaveCallDataService] CallSid: {}", (Object)callData.getCallSid());
            log.error("\u274c [DualSaveCallDataService] FULL STACK TRACE:", (Throwable)e);
        }
        finally {
            TenantContext.clear();
            log.info("\ud83e\uddf9 [DualSaveCallDataService] TenantContext cleared after TENANT save");
        }
    }

    private InboundCallData cloneCallData(InboundCallData source) {
        return InboundCallData.builder().callSid(source.getCallSid()).provider(source.getProvider()).fromNumber(source.getFromNumber()).toNumber(source.getToNumber()).direction(source.getDirection()).callStatus(source.getCallStatus()).startTime(source.getStartTime()).endTime(source.getEndTime()).duration(source.getDuration()).fromCity(source.getFromCity()).fromState(source.getFromState()).fromZip(source.getFromZip()).fromCountry(source.getFromCountry()).toCity(source.getToCity()).toState(source.getToState()).toZip(source.getToZip()).toCountry(source.getToCountry()).accountSid(source.getAccountSid()).apiVersion(source.getApiVersion()).called(source.getCalled()).caller(source.getCaller()).calledCity(source.getCalledCity()).calledCountry(source.getCalledCountry()).calledState(source.getCalledState()).calledZip(source.getCalledZip()).callerCity(source.getCallerCity()).callerCountry(source.getCallerCountry()).callerState(source.getCallerState()).callerZip(source.getCallerZip()).callToken(source.getCallToken()).forwardedFrom(source.getForwardedFrom()).parentCallSid(source.getParentCallSid()).recordingSid(source.getRecordingSid()).recordingUrl(source.getRecordingUrl()).stirVerstat(source.getStirVerstat()).build();
    }

    @Generated
    public DualSaveCallDataService(InboundCallDataRepository callDataRepository) {
        this.callDataRepository = callDataRepository;
    }
}

