/*
 * Decompiled with CFR 0.152.
 */
package com.saas.tenant.controller;

import com.saas.shared.core.TenantContext;
import com.saas.tenant.entity.CallCostRecord;
import com.saas.tenant.service.CallCostTrackingService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tenant/costs"})
@PreAuthorize(value="hasRole('TENANT_USER')")
public class TenantCostController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantCostController.class);
    private final CallCostTrackingService callCostTrackingService;

    @GetMapping(value={"/summary"})
    public ResponseEntity<Map<String, Object>> getCostSummary(@RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime endDate) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udcca Tenant {} requesting cost summary - start: {}, end: {}", new Object[]{tenantId, startDate, endDate});
        Map summary = this.callCostTrackingService.getTenantCostSummary(tenantId, startDate, endDate);
        return ResponseEntity.ok((Object)summary);
    }

    @GetMapping
    public ResponseEntity<List<CallCostRecord>> getAllCosts(@RequestParam(required=false) String provider, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime endDate) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udccb Tenant {} requesting all costs - provider: {}, start: {}, end: {}", new Object[]{tenantId, provider, startDate, endDate});
        List costs = provider != null ? this.callCostTrackingService.getCostsByProvider(provider) : (startDate != null && endDate != null ? this.callCostTrackingService.getCostsByDateRange(startDate, endDate) : this.callCostTrackingService.getAllCosts());
        return ResponseEntity.ok((Object)costs);
    }

    @GetMapping(value={"/call/{callSid}"})
    public ResponseEntity<CallCostRecord> getCostByCallSid(@PathVariable String callSid) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udd0d Tenant {} requesting cost for call: {}", (Object)tenantId, (Object)callSid);
        return this.callCostTrackingService.getCallCostByCallSid(callSid).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/total"})
    public ResponseEntity<BigDecimal> getTotalCost(@RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime endDate) {
        BigDecimal total;
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udcb0 Tenant {} requesting total cost - start: {}, end: {}", new Object[]{tenantId, startDate, endDate});
        if (startDate != null && endDate != null) {
            List costs = this.callCostTrackingService.getCostsByDateRange(startDate, endDate);
            total = costs.stream().map(CallCostRecord::getCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            total = this.callCostTrackingService.getAllCosts().stream().map(CallCostRecord::getCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return ResponseEntity.ok((Object)total);
    }

    @GetMapping(value={"/by-provider"})
    public ResponseEntity<Map<String, BigDecimal>> getCostsByProvider() {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udcca Tenant {} requesting costs grouped by provider", (Object)tenantId);
        List allCosts = this.callCostTrackingService.getAllCosts();
        Map<String, BigDecimal> costsByProvider = allCosts.stream().collect(Collectors.groupingBy(CallCostRecord::getProvider, Collectors.reducing(BigDecimal.ZERO, CallCostRecord::getCost, BigDecimal::add)));
        return ResponseEntity.ok(costsByProvider);
    }

    @Generated
    public TenantCostController(CallCostTrackingService callCostTrackingService) {
        this.callCostTrackingService = callCostTrackingService;
    }
}

