/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.tenant.entity.CallCostRecord;
import com.saas.tenant.entity.InboundCallRequest;
import com.saas.tenant.service.CallCostTrackingService;
import com.saas.tenant.service.InboundCallService;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voip/elevenlabs"})
public class ElevenLabsPostCallWebhookController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElevenLabsPostCallWebhookController.class);
    private final ObjectMapper objectMapper;
    private final InboundCallService inboundCallService;
    private final CallCostTrackingService callCostTrackingService;
    private final PhoneNumberRepository phoneNumberRepository;
    private final TenantRepository tenantRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/post-call-webhook"})
    public ResponseEntity<String> handlePostCallWebhook(@RequestBody Map<String, Object> payload) {
        try {
            log.info("=== ELEVENLABS POST-CALL WEBHOOK RECEIVED ===");
            log.info("Payload: {}", (Object)this.objectMapper.writeValueAsString(payload));
            String eventType = (String)payload.get("type");
            if (!"post_call_transcription".equals(eventType)) {
                log.warn("\u26a0\ufe0f Unsupported event type: {}", (Object)eventType);
                return ResponseEntity.ok((Object)"OK");
            }
            Map data = (Map)payload.get("data");
            if (data == null) {
                log.warn("\u26a0\ufe0f No data in webhook payload");
                return ResponseEntity.ok((Object)"OK");
            }
            String conversationId = (String)data.get("conversation_id");
            String agentId = (String)data.get("agent_id");
            List transcript = (List)data.get("transcript");
            Map metadata = (Map)data.get("metadata");
            Map analysis = (Map)data.get("analysis");
            log.info("\ud83d\udcde Conversation ID: {}, Agent ID: {}", (Object)conversationId, (Object)agentId);
            if (metadata != null) {
                String schemaName;
                Integer callDurationSecs = (Integer)metadata.get("call_duration_secs");
                Integer cost = (Integer)metadata.get("cost");
                Long startTimeUnix = ((Number)metadata.get("start_time_unix_secs")).longValue();
                Map dynamicVars = (Map)metadata.get("dynamic_variables");
                log.info("\u23f1\ufe0f Duration: {} seconds, Cost: {} credits", (Object)callDurationSecs, (Object)cost);
                String phoneNumber = null;
                if (dynamicVars != null) {
                    phoneNumber = (String)dynamicVars.get("To");
                }
                if ((schemaName = this.identifyTenantSchema(phoneNumber)) == null) {
                    log.warn("\u26a0\ufe0f Cannot identify tenant for phone: {}", (Object)phoneNumber);
                    return ResponseEntity.ok((Object)"OK");
                }
                TenantContext.setTenantId((String)schemaName);
                try {
                    this.savePatientData(conversationId, transcript, analysis);
                    log.info("\u2705 ElevenLabs patient data saved to tenant schema: {}", (Object)schemaName);
                }
                finally {
                    TenantContext.clear();
                }
                this.saveCostRecord(conversationId, callDurationSecs, cost, startTimeUnix, phoneNumber);
                log.info("\u2705 ElevenLabs cost record saved to admin database (saas_db)");
            }
            return ResponseEntity.ok((Object)"OK");
        }
        catch (Exception e) {
            log.error("\u274c Error processing ElevenLabs post-call webhook", (Throwable)e);
            return ResponseEntity.status((int)500).body((Object)"Error");
        }
    }

    private void savePatientData(String conversationId, List<Map<String, Object>> transcript, Map<String, Object> analysis) {
        try {
            if (analysis == null) {
                log.warn("\u26a0\ufe0f No analysis data available");
                return;
            }
            List evaluationResults = (List)analysis.get("evaluation_criteria_results");
            if (evaluationResults == null || evaluationResults.isEmpty()) {
                log.warn("\u26a0\ufe0f No evaluation criteria results");
                return;
            }
            InboundCallRequest callRequest = new InboundCallRequest();
            callRequest.setCallSid(conversationId);
            for (Map result : evaluationResults) {
                String criteriaName = (String)result.get("criteria");
                Object value = result.get("value");
                if (value == null) continue;
                if (criteriaName.contains("patient_name") || criteriaName.contains("nom")) {
                    callRequest.setNom(value.toString());
                    continue;
                }
                if (criteriaName.contains("phone") || criteriaName.contains("telephone")) {
                    callRequest.setTelephone(value.toString());
                    continue;
                }
                if (criteriaName.contains("birthdate") || criteriaName.contains("date_naissance")) {
                    callRequest.setDateNaissance(value.toString());
                    continue;
                }
                if (criteriaName.contains("illness") || criteriaName.contains("maladie")) {
                    callRequest.setMaladie(value.toString());
                    continue;
                }
                if (criteriaName.contains("doctor") || criteriaName.contains("medecin")) {
                    callRequest.setDoctorName(value.toString());
                    continue;
                }
                if (criteriaName.contains("appointment_date")) {
                    callRequest.setMotifVisite(value.toString());
                    continue;
                }
                if (!criteriaName.contains("confirmed")) continue;
                callRequest.setAppointmentConfirmed(Boolean.valueOf(Boolean.parseBoolean(value.toString())));
            }
            if (transcript != null) {
                callRequest.setConversationTranscript(this.objectMapper.writeValueAsString(transcript));
            }
            this.inboundCallService.savePatientRequest(callRequest);
            log.info("\ud83d\udccb Patient data saved from ElevenLabs - Name: {}, Doctor: {}", (Object)callRequest.getNom(), (Object)callRequest.getDoctorName());
        }
        catch (Exception e) {
            log.error("\u274c Error saving patient data from ElevenLabs", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCostRecord(String conversationId, Integer durationSecs, Integer credits, Long startTimeUnix, String phoneNumber) {
        try {
            TenantContext.setTenantId((String)"saas_db");
            CallCostRecord costRecord = new CallCostRecord();
            costRecord.setCallSid(conversationId);
            costRecord.setProvider("ELEVENLABS");
            costRecord.setCallDurationSeconds(durationSecs);
            BigDecimal costUsd = this.calculateElevenLabsCost(credits);
            costRecord.setCost(costUsd);
            costRecord.setCurrency("USD");
            HashMap<String, Integer> details = new HashMap<String, Integer>();
            details.put("credits", credits);
            details.put("credits_per_minute", 667);
            costRecord.setCostDetails(details);
            LocalDateTime startTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(startTimeUnix), ZoneId.systemDefault());
            costRecord.setCallStartTime(startTime);
            costRecord.setCallEndTime(startTime.plusSeconds(durationSecs.intValue()));
            costRecord.setToNumber(phoneNumber);
            this.callCostTrackingService.saveCallCost(costRecord);
            log.info("\ud83d\udcb0 ElevenLabs cost record saved to ADMIN database (saas_db) - {} credits = ${} USD", (Object)credits, (Object)costUsd);
        }
        catch (Exception e) {
            log.error("\u274c Error saving cost record to admin database", (Throwable)e);
        }
        finally {
            TenantContext.clear();
        }
    }

    private BigDecimal calculateElevenLabsCost(Integer credits) {
        double costPer10kCredits = 1.0;
        double costUsd = (double)credits.intValue() / 10000.0 * costPer10kCredits;
        return BigDecimal.valueOf(costUsd).setScale(6, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String identifyTenantSchema(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        try {
            TenantContext.setTenantId((String)"saas_db");
            Optional phoneOpt = this.phoneNumberRepository.findByPhoneNumber(phoneNumber);
            if (phoneOpt.isEmpty()) {
                String string = null;
                return string;
            }
            String tenantId = ((PhoneNumber)phoneOpt.get()).getTenantId();
            Optional tenantOpt = this.tenantRepository.findByTenantId(tenantId);
            if (tenantOpt.isEmpty()) {
                String string = null;
                return string;
            }
            String string = ((Tenant)tenantOpt.get()).getSchemaName();
            return string;
        }
        finally {
            TenantContext.clear();
        }
    }

    @Generated
    public ElevenLabsPostCallWebhookController(ObjectMapper objectMapper, InboundCallService inboundCallService, CallCostTrackingService callCostTrackingService, PhoneNumberRepository phoneNumberRepository, TenantRepository tenantRepository) {
        this.objectMapper = objectMapper;
        this.inboundCallService = inboundCallService;
        this.callCostTrackingService = callCostTrackingService;
        this.phoneNumberRepository = phoneNumberRepository;
        this.tenantRepository = tenantRepository;
    }
}

