/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.saas.voip.factory.VoiceAiSessionFactory;
import com.saas.voip.handler.AiSessionHandler;
import com.saas.voip.handler.OpenAiSessionHandler;
import com.saas.voip.service.OpenAIRealtimeService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class TwilioMediaStreamHandler
extends TextWebSocketHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwilioMediaStreamHandler.class);
    private final VoiceAiSessionFactory voiceAiSessionFactory;
    private final OpenAIRealtimeService openAIRealtimeService;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, String> sessionStreamIds = new ConcurrentHashMap();
    private final Map<String, AiSessionHandler> sessionHandlers = new ConcurrentHashMap();
    private final Map<String, Map<String, String>> sessionCallData = new ConcurrentHashMap();

    public void afterConnectionEstablished(WebSocketSession session) {
        log.info("=== TWILIO WEBSOCKET CONNECTED === Session ID: {}", (Object)session.getId());
        log.info("Remote address: {}", (Object)session.getRemoteAddress());
        log.info("URI: {}", (Object)session.getUri());
        AiSessionHandler handler = this.voiceAiSessionFactory.createHandler();
        this.sessionHandlers.put(session.getId(), handler);
        this.sessionCallData.put(session.getId(), new HashMap());
        log.info("Created AI session handler: {}", (Object)handler.getClass().getSimpleName());
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) {
        try {
            String event;
            JsonNode data = this.objectMapper.readTree((String)message.getPayload());
            switch (event = data.get("event").asText()) {
                case "media": {
                    this.handleMediaEvent(session, data);
                    break;
                }
                case "start": {
                    this.handleStartEvent(session, data);
                    break;
                }
                case "stop": {
                    this.handleStopEvent(session, data);
                    break;
                }
                default: {
                    log.debug("Received non-media event: {}", (Object)event);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Error processing Twilio message", (Throwable)e);
        }
    }

    private void handleMediaEvent(WebSocketSession session, JsonNode data) {
        try {
            AiSessionHandler handler = (AiSessionHandler)this.sessionHandlers.get(session.getId());
            if (handler != null) {
                handler.onMediaFrame(session, data.toString());
            }
        }
        catch (Exception e) {
            log.error("Error handling media event", (Throwable)e);
        }
    }

    private void handleStartEvent(WebSocketSession session, JsonNode data) {
        try {
            JsonNode startNode = data.get("start");
            String streamSid = startNode.get("streamSid").asText();
            String callSid = startNode.has("callSid") ? startNode.get("callSid").asText() : null;
            JsonNode customParameters = startNode.has("customParameters") ? startNode.get("customParameters") : null;
            String fromNumber = customParameters != null && customParameters.has("From") ? customParameters.get("From").asText() : null;
            String toNumber = customParameters != null && customParameters.has("To") ? customParameters.get("To").asText() : null;
            this.sessionStreamIds.put(session.getId(), streamSid);
            Map callData = (Map)this.sessionCallData.get(session.getId());
            if (callData != null) {
                callData.put("callSid", callSid);
                callData.put("from", fromNumber);
                callData.put("to", toNumber);
            }
            log.info("\ud83d\udcde Incoming stream started: streamSid={}, callSid={}, from={}, to={}, session={}", new Object[]{streamSid, callSid, fromNumber, toNumber, session.getId()});
            AiSessionHandler handler = (AiSessionHandler)this.sessionHandlers.get(session.getId());
            if (handler != null) {
                if (handler instanceof OpenAiSessionHandler && callSid != null) {
                    this.openAIRealtimeService.setCallSid(session.getId(), callSid);
                }
                if (callSid != null) {
                    log.info("\ud83d\ude80 Calling onClientConnect for handler: {}", (Object)handler.getClass().getSimpleName());
                    handler.onClientConnect(session, streamSid, callSid, fromNumber, toNumber);
                } else {
                    log.warn("\u26a0\ufe0f Cannot call onClientConnect: callSid is null");
                }
            } else {
                log.error("\u274c No handler found for session: {}", (Object)session.getId());
            }
        }
        catch (Exception e) {
            log.error("Error handling start event", (Throwable)e);
        }
    }

    private void handleStopEvent(WebSocketSession session, JsonNode data) {
        log.info("Stream stopped for session: {}", (Object)session.getId());
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) {
        log.info("=== TWILIO WEBSOCKET DISCONNECTED === Session: {}, status: {}", (Object)session.getId(), (Object)status);
        try {
            AiSessionHandler handler = (AiSessionHandler)this.sessionHandlers.remove(session.getId());
            if (handler != null) {
                handler.onClose(session);
            }
        }
        catch (Exception e) {
            log.error("Error closing AI session handler", (Throwable)e);
        }
        this.sessionStreamIds.remove(session.getId());
        this.sessionCallData.remove(session.getId());
        this.openAIRealtimeService.disconnectFromOpenAI(session);
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) {
        log.error("=== WEBSOCKET TRANSPORT ERROR === Session: {}", (Object)session.getId(), (Object)exception);
    }

    public String getStreamSid(String sessionId) {
        return (String)this.sessionStreamIds.get(sessionId);
    }

    @Generated
    public TwilioMediaStreamHandler(VoiceAiSessionFactory voiceAiSessionFactory, OpenAIRealtimeService openAIRealtimeService) {
        this.voiceAiSessionFactory = voiceAiSessionFactory;
        this.openAIRealtimeService = openAIRealtimeService;
    }
}

