/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class ZiwoApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZiwoApiService.class);
    private final RestTemplate restTemplate = new RestTemplate();
    @Value(value="${ziwo.api.key:}")
    private String apiKey;
    @Value(value="${ziwo.instance.name:}")
    private String instanceName;
    private static final String BASE_URL_PATTERN = "https://{instance}-api.aswat.co";

    public Map<String, Object> getCallDetails(String callId) {
        if (this.apiKey == null || this.apiKey.isEmpty() || this.instanceName == null || this.instanceName.isEmpty()) {
            log.warn("Ziwo API key or instance name not configured");
            return null;
        }
        try {
            Map body;
            String url = BASE_URL_PATTERN.replace("{instance}", this.instanceName) + "/calls/" + callId;
            HttpHeaders headers = new HttpHeaders();
            headers.set("api_key", this.apiKey);
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, Map.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null && (body = (Map)response.getBody()).containsKey("result") && Boolean.TRUE.equals(body.get("result"))) {
                return (Map)body.get("content");
            }
            log.warn("Failed to get call details from Ziwo: {}", (Object)response.getStatusCode());
            return null;
        }
        catch (HttpClientErrorException e) {
            log.error("Error calling Ziwo API for call details: {}", (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.error("Unexpected error calling Ziwo API", (Throwable)e);
            return null;
        }
    }

    public String getRecordingUrl(String callId) {
        if (this.apiKey == null || this.apiKey.isEmpty() || this.instanceName == null || this.instanceName.isEmpty()) {
            log.warn("Ziwo API key or instance name not configured");
            return null;
        }
        try {
            List recordings;
            Object content;
            Map body;
            String url = BASE_URL_PATTERN.replace("{instance}", this.instanceName) + "/recordings?call_id=" + callId;
            HttpHeaders headers = new HttpHeaders();
            headers.set("api_key", this.apiKey);
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, Map.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null && (body = (Map)response.getBody()).containsKey("result") && Boolean.TRUE.equals(body.get("result")) && (content = body.get("content")) instanceof List && !(recordings = (List)content).isEmpty()) {
                return (String)((Map)recordings.get(0)).get("url");
            }
            log.warn("No recording found for call: {}", (Object)callId);
            return null;
        }
        catch (Exception e) {
            log.error("Error getting recording URL from Ziwo", (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> makeOutboundCall(String from, String to, String aiAgentId) {
        if (this.apiKey == null || this.apiKey.isEmpty() || this.instanceName == null || this.instanceName.isEmpty()) {
            log.warn("Ziwo API key or instance name not configured");
            return null;
        }
        try {
            Map body;
            HttpEntity request;
            ResponseEntity response;
            String url = BASE_URL_PATTERN.replace("{instance}", this.instanceName) + "/calls";
            HttpHeaders headers = new HttpHeaders();
            headers.set("api_key", this.apiKey);
            headers.setContentType(MediaType.APPLICATION_JSON);
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("from", from);
            requestBody.put("to", to);
            if (aiAgentId != null && !aiAgentId.isEmpty()) {
                requestBody.put("ai_agent_id", aiAgentId);
            }
            if ((response = this.restTemplate.exchange(url, HttpMethod.POST, request = new HttpEntity(requestBody, (MultiValueMap)headers), Map.class, new Object[0])).getStatusCode().is2xxSuccessful() && response.getBody() != null && (body = (Map)response.getBody()).containsKey("result") && Boolean.TRUE.equals(body.get("result"))) {
                return (Map)body.get("content");
            }
            log.warn("Failed to make outbound call via Ziwo: {}", (Object)response.getStatusCode());
            return null;
        }
        catch (Exception e) {
            log.error("Error making outbound call via Ziwo", (Throwable)e);
            return null;
        }
    }

    public boolean hangupCall(String callId) {
        if (this.apiKey == null || this.apiKey.isEmpty() || this.instanceName == null || this.instanceName.isEmpty()) {
            log.warn("Ziwo API key or instance name not configured");
            return false;
        }
        try {
            String url = BASE_URL_PATTERN.replace("{instance}", this.instanceName) + "/calls/" + callId + "/hangup";
            HttpHeaders headers = new HttpHeaders();
            headers.set("api_key", this.apiKey);
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request, Map.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                Map body = (Map)response.getBody();
                return body.containsKey("result") && Boolean.TRUE.equals(body.get("result"));
            }
            return false;
        }
        catch (Exception e) {
            log.error("Error hanging up call via Ziwo", (Throwable)e);
            return false;
        }
    }

    public Map<String, Object> sendSms(String from, String to, String message) {
        if (this.apiKey == null || this.apiKey.isEmpty() || this.instanceName == null || this.instanceName.isEmpty()) {
            log.warn("Ziwo API key or instance name not configured");
            return null;
        }
        try {
            Map body;
            String url = BASE_URL_PATTERN.replace("{instance}", this.instanceName) + "/sms";
            HttpHeaders headers = new HttpHeaders();
            headers.set("api_key", this.apiKey);
            headers.setContentType(MediaType.APPLICATION_JSON);
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("from", from);
            requestBody.put("to", to);
            requestBody.put("message", message);
            HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request, Map.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null && (body = (Map)response.getBody()).containsKey("result") && Boolean.TRUE.equals(body.get("result"))) {
                return (Map)body.get("content");
            }
            log.warn("Failed to send SMS via Ziwo: {}", (Object)response.getStatusCode());
            return null;
        }
        catch (Exception e) {
            log.error("Error sending SMS via Ziwo", (Throwable)e);
            return null;
        }
    }
}

