/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.service;

import com.saas.voip.service.ZiwoApiService;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ZiwoVoiceAIService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZiwoVoiceAIService.class);
    private final ZiwoApiService ziwoApiService;

    public Map<String, Object> startAIAgent(String callId, String aiAgentId) {
        log.info("Starting Ziwo AI Agent for callId: {}, agentId: {}", (Object)callId, (Object)aiAgentId);
        log.warn("Ziwo AI Agent is automatically started via workflow configuration in Ziwo dashboard. No explicit API call needed to start the agent on an active call. Configure the AI Agent workflow in your Ziwo dashboard and assign it to your phone number.");
        return Map.of("status", "configured_via_dashboard", "message", "Ziwo AI Agent starts automatically when call is routed to configured workflow", "callId", callId);
    }

    public boolean stopAIAgent(String callId) {
        log.info("Stopping Ziwo AI Agent for callId: {}", (Object)callId);
        return this.ziwoApiService.hangupCall(callId);
    }

    public String getConversationTranscript(String callId) {
        log.info("Getting Ziwo conversation transcript for callId: {}", (Object)callId);
        Map callDetails = this.ziwoApiService.getCallDetails(callId);
        if (callDetails != null && callDetails.containsKey("transcript")) {
            return callDetails.get("transcript").toString();
        }
        return null;
    }

    public Map<String, Object> getCallVariables(String callId) {
        log.info("Getting Ziwo call variables for callId: {}", (Object)callId);
        Map callDetails = this.ziwoApiService.getCallDetails(callId);
        if (callDetails != null && callDetails.containsKey("variables")) {
            Map variables = (Map)callDetails.get("variables");
            return variables;
        }
        return null;
    }

    @Generated
    public ZiwoVoiceAIService(ZiwoApiService ziwoApiService) {
        this.ziwoApiService = ziwoApiService;
    }
}

