package com.saas.admin.repository;

import com.saas.admin.entity.TenantVoipConfig;
import com.saas.shared.enums.Provider;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

/**
 * Repository for tenant-specific VoIP configurations.
 * Enables dynamic provider settings per tenant.
 */
@Repository
public interface TenantVoipConfigRepository extends JpaRepository<TenantVoipConfig, Long> {
    
    /**
     * Find VoIP config by tenant and provider (unique combination)
     */
    Optional<TenantVoipConfig> findByTenantIdAndProvider(String tenantId, Provider provider);
    
    /**
     * Find all VoIP configs for a tenant
     */
    List<TenantVoipConfig> findByTenantId(String tenantId);
    
    /**
     * Find all configs for a specific provider
     */
    List<TenantVoipConfig> findByProvider(Provider provider);
    
    /**
     * Find active VoIP config by tenant and provider
     */
    Optional<TenantVoipConfig> findByTenantIdAndProviderAndIsActive(String tenantId, Provider provider, Boolean isActive);
    
    /**
     * Find all active configs for a tenant
     */
    List<TenantVoipConfig> findByTenantIdAndIsActive(String tenantId, Boolean isActive);
}
